/***************************************************************************
 *   Copyright (C) 2005--2006 by Stefan Kebekus                            *
 *   kebekus@kde.org                                                       *
 *                                                                         *
 *   Copyright (C) 2005--2006 by Wilfried Huss                             *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.          *
 ***************************************************************************/

#include <kmessagebox.h>
#include <kparts/genericfactory.h>
#include <kprinter.h>
#include <ktemporaryfile.h>
#include <qtooltip.h>
#include <kactioncollection.h>

#include "pageRangeWidget.h"
#include "psMultipage.h"

K_EXPORT_COMPONENT_FACTORY(ligaturePlugin_PS, KGenericFactory<PsMultiPage>("ligaturePlugin_PS"))

PsMultiPage::PsMultiPage(QObject *parent, const QStringList&)
  : ligaturePluginGUI(parent),
    psRenderer(this)
{
  setXMLFile("psMultipage.rc");

  /* It is very important that this method is called in the
     constructor. Otherwise ligaturePluginGUI does not know how to render
     files, and crashes may result. */
  setRenderer(&psRenderer);

  docInfoAction = actionCollection()->addAction("info_ps");
  docInfoAction->setText(i18n("Document &Properties"));
  docInfoAction->setIcon(KIcon("info"));
  connect(docInfoAction, SIGNAL(triggered()), this, SLOT(slotShowInfo()));
  deletePagesAction = actionCollection()->addAction("delete_pages");
  deletePagesAction->setText(i18n("Delete Pages..."));
  connect(deletePagesAction, SIGNAL(triggered()), this, SLOT(slotDeletePages()));
  enableActions(false);
}


PsMultiPage::~PsMultiPage()
{
}


KAboutData* PsMultiPage::createAboutData()
{
  /* You obviously want to change this to match your setup */
  KAboutData* about = new KAboutData("kpsview", I18N_NOOP("KPSView"), "0.1",
                          I18N_NOOP("Ligature PS Plugin"),
                          KAboutData::License_GPL,
                          "Wilfried Huss",
                          I18N_NOOP("This program displays PostScript files."));

  about->addAuthor ("Stefan Kebekus",
                    I18N_NOOP("Ligature plugin template"),
                    "kebekus@kde.org",
                    "http://www.mi.uni-koeln.de/~kebekus");

  about->addAuthor ("Wilfried Huss",
                    I18N_NOOP("PS file loading"),
                    "Wilfried.Huss@gmx.at");

  return about;
}


void PsMultiPage::setFile(bool r)
{
  enableActions(r);
}


void PsMultiPage::print()
{
  // Paranoid safety checks
  if (psRenderer.isEmpty())
    return;

  // Allocate the printer structure
  KPrinter *printer = getPrinter(false);
  if (printer == 0)
    return;

  // initialize the printer using the print dialog
  if ( printer->setup(parentWdg, i18n("Print %1", m_file.section('/', -1))) ) {

    // Now do the printing.
    QList<int> pageList = printer->pageList();
    if (pageList.isEmpty())
      printer->abort();
    else {
      if (pageList.size() == psRenderer.totalPages())
	// Print the whole document. This is easy: just send the PS
	// file to the printer
	printer->printFiles( QStringList(m_file), false );
      else {
	KTemporaryFile tmpPSFile;
	tmpPSFile.setSuffix(".ps");
	tmpPSFile.open();

	if (psRenderer.generatePSFileForPage(tmpPSFile.fileName(), pageList))
	  printer->printFiles(QStringList(tmpPSFile.fileName()), true );
	else
	  printer->abort();
      }

      delete printer;
    }
  }

}

void PsMultiPage::slotDeletePages()
{
  // deleting pages from an empty document doesn't make much sense
  if (dataModel->numberOfPages() == 0)
    return;

  KDialog dialog( parentWdg);
  dialog.setCaption( i18n("Delete Pages") );
  dialog.setButtons( KDialog::Ok|KDialog::Cancel );
  dialog.setDefaultButton( KDialog::Ok );

  PageRangeWidget range( 1, dataModel->numberOfPages(), dataModel->currentPageNumber(), &dialog );
  range.setToolTip( i18n( "Select the pages you wish to delete." ) );
  dialog.setButtonText(KDialog::Ok, i18n("Delete Pages"));
  dialog.setMainWidget(&range);
  if (dialog.exec() != QDialog::Accepted)
    return;

  psRenderer.deletePages(range.getFrom(), range.getTo());
  dataModel->deletePages(range.getFrom(), range.getTo());
  emit documentHasBeenModified();
}


void PsMultiPage::slotShowInfo()
{
  // deleting pages from an empty document doesn't make much sense
  if (dataModel->numberOfPages() == 0)
    return;

  if (psRenderer.showInfo())
    emit documentHasBeenModified();
}

bool PsMultiPage::slotSave(const QString &fileName)
{
  // Paranoid safety checks
  if (psRenderer.isEmpty())
    return false;
  if (fileName.isEmpty())
    return false;

  bool r = psRenderer.save(fileName);
  if (r == false)
    KMessageBox::error(parentWdg, i18n("<qt>Error saving the document to the file <strong>%1</strong>. The document is <strong>not</strong> saved.</qt>", fileName),
                       i18n("Error saving document"));
  return r;
}


#include "psMultipage.moc"
