// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
//
// Class: documentRenderer
//
// Abstract Widget for displaying document types
// Needs to be implemented from the actual parts
// using ligature
// Part of Ligature - A generic interface for document viewers.
//
// (C) 2004-2005 Wilfried Huss
// (C) 2004-2006 Stefan Kebekus.
//  Distributed under the GPL.

#include <config.h>

#include "documentRenderer.h"
#include "ligaturePluginGUI.h"


DocumentRenderer::DocumentRenderer(ligaturePluginGUI* _multiPage)
  :
    mutex(QMutex::Recursive),
    accessibilityBackground(false),
    accessibilityBackgroundColor(QColor(255,255,255)),
    multiPage(_multiPage)
{
  parentWidget = 0;
  numPages = 0;
  _isModified = false;
}


DocumentRenderer::~DocumentRenderer()
{
  clear();
}


void DocumentRenderer::clear()
{
  // Wait for all access to this DocumentRenderer to finish
  QMutexLocker lock(&mutex);

  numPages = 0;
  pageSizes.clear();
  bookmarks.clear();
  _isModified = false;
}

void DocumentRenderer::setAccessibleBackground(bool accessibleMode, const QColor& background)
{
  // Wait for all access to this DocumentRenderer to finish
  QMutexLocker lock(&mutex);

  accessibilityBackground = accessibleMode;
  accessibilityBackgroundColor = background;
}

SimplePageSize DocumentRenderer::sizeOfPage(const PageNumber& page) const
{
  // Wait for all access to this DocumentRenderer to finish
  //QMutexLocker locker(&mutex);

  if (!page.isValid())
    return SimplePageSize();
  if (page > totalPages())
    return SimplePageSize();
  if (page > pageSizes.size())
    return SimplePageSize();

  return pageSizes[page-1];
}


RenderedDocumentPagePixmap* DocumentRenderer::getText(const JobId& id)
{
  // We are only interrested in the textual data, so we can use a dummy value for the resolution.
  return drawPage(id);
}

bool DocumentRenderer::isValidFile(const QString&) const
{
  return true;
}


Anchor DocumentRenderer::parseReference(const QString &reference)
{
  if (isEmpty())
    return Anchor();

  // If the reference is a number, which we'll interpret as a
  // page number.
  bool ok;
  int page = reference.toInt(&ok);
  if (ok == true)
  {
    if (page < 1)
      page = 1;
    if (page > totalPages())
      page = totalPages();

    return Anchor(page, Length());
  }

  // If the reference is not a number, return an empty anchor.
  return Anchor();
}


PageNumber DocumentRenderer::totalPages() const
{
  PageNumber temp = numPages;
  return temp;
}

#include "documentRenderer.moc"
