// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
//
// Class: RenderedDocumentPagePrinter
//
// Widget for displaying TeX DVI files.
// Part of KDVI- A previewer for TeX DVI files.
//
// (C) 2005 Stefan Kebekus. Distributed under the GPL.

#ifndef _rendereddocumentpageprinter_h_
#define _rendereddocumentpageprinter_h_

#include "ligature_export.h"

#include "renderedDocumentPage.h"

#include <QPainter>

class KPrinter;


class LIGATUREPLUGINGUI_EXPORT RenderedDocumentPagePrinter: public RenderedDocumentPage
{
public:
  RenderedDocumentPagePrinter(KPrinter *kp);

  virtual ~RenderedDocumentPagePrinter() { delete printerPainter; }

  /** Returns a pointer to the paintDevice, in this implementation
      either a QPrinter. The pointer returned is valid as long as
      *this RenderedDocumentPage exists. This method is used by the
      renderer to draw on the page. */
  virtual QPainter *getPainter() { return printerPainter; }

  virtual QSize size();

  /** This method does nothing. In particular, it does NOT delete the
      QPainter. The QPainter is deleted automatically when this
      RenderedDocumentPagePrinter is destructed. */
  virtual void returnPainter(QPainter *) {;}

private:
  KPrinter *printer;
  QPainter *printerPainter;
};


#endif
