// -*- Mode: C++; c-basic-offset: 2; indent-tabs-mode: nil; c-brace-offset: 0; -*-
/***************************************************************************
 *   Copyright (C) 2005 by Wilfried Huss                                   *
 *   Wilfried.Huss@gmx.at                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#include <config.h>

#include "searchWidget.h"

#include <kglobal.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <klocale.h>

#include <QCheckBox>
#include <QHBoxLayout>
#include <QKeyEvent>
#include <QLabel>
#include <QPushButton>
#include <QToolTip>


SearchWidget::SearchWidget(QWidget* parent, Qt::WFlags fl)
  : QWidget(parent, fl)
{
  setObjectName("SearchWidget");

  setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Fixed);

  layout = new QHBoxLayout(this);
  layout->setMargin(4);
  layout->setSpacing(6);

  stopButton = new QPushButton(this);
  stopButton->setIcon(KIconLoader::global()->loadIcon("stop", K3Icon::Small, K3Icon::SizeSmall));
  layout->addWidget(stopButton);

  searchLabel = new QLabel(this);
  searchLabel->setText(i18n("Search:"));
  layout->addWidget(searchLabel);

  searchText = new KLineEdit(this);
  layout->addWidget(searchText);

  searchLabel->setBuddy(searchText);

  findPrevButton = new QPushButton(this);
  findPrevButton->setIcon(KIconLoader::global()->loadIcon("back", K3Icon::NoGroup, K3Icon::SizeSmall));
  findPrevButton->setToolTip(i18n("Find previous"));
  layout->addWidget(findPrevButton);

  findNextButton = new QPushButton(this);
  findNextButton->setIcon(KIconLoader::global()->loadIcon("forward", K3Icon::NoGroup, K3Icon::SizeSmall));
  findNextButton->setToolTip(i18n("Find next"));
  layout->addWidget(findNextButton);

  caseSensitiveCheckBox = new QCheckBox(this);
  caseSensitiveCheckBox->setText(i18n("Case sensitive"));
  layout->addWidget(caseSensitiveCheckBox);

  connect(stopButton, SIGNAL(clicked()), this, SIGNAL(stopSearch()));

  connect(findNextButton, SIGNAL(clicked()), this, SIGNAL(findNextText()));
  connect(findPrevButton, SIGNAL(clicked()), this, SIGNAL(findPrevText()));

  connect(searchText, SIGNAL(textChanged(const QString&)), this, SLOT(textChanged()));

  textChanged();
}

SearchWidget::~SearchWidget()
{
}

QString SearchWidget::getText() const
{
  return searchText->text();
}

bool SearchWidget::caseSensitive() const
{
  return caseSensitiveCheckBox->isChecked();
}

void SearchWidget::textChanged()
{
  bool empty = searchText->text().isEmpty();

  findNextButton->setDisabled(empty);
  findPrevButton->setDisabled(empty);
  emit searchEnabled(!empty);
}

void SearchWidget::show()
{
  searchText->setEnabled(true);
  searchText->selectAll();
  QWidget::show();
  emit searchEnabled(!searchText->text().isEmpty());
}

void SearchWidget::hide()
{
  searchText->setEnabled(false);
  QWidget::hide();
}

void SearchWidget::setFocus()
{
  searchText->setFocus();
}

void SearchWidget::keyPressEvent(QKeyEvent* e)
{
  if (e->key() == Qt::Key_Escape)
    emit stopSearch();

  if (e->key() == Qt::Key_Return || e->key() == Qt::Key_Enter)
  {
    if (e->modifiers() == Qt::ShiftModifier)
      emit findPrevText();
    else
      emit findNextText();
  }
}

#include "searchWidget.moc"
