/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <kdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef KMJOBVIEWER_H
#define KMJOBVIEWER_H

#if !defined( _KDEPRINT_COMPILE ) && defined( __GNUC__ )
#warning internal header, do not use except if you are a KDEPrint developer
#endif

#include <kmainwindow.h>
#include "kmprinterpage.h"
#include "kpreloadobject.h"
#include <QList>

class KMJobManager;
class KMJob;
class JobItem;
class QMenu;
class KMPrinter;
class QTimer;
class QLineEdit;
class QCheckBox;
class QTreeWidget;
class QTreeWidgetItem;

/**
 * @internal
 * This class is internal to KDEPrint and is not intended to be
 * used outside it. Please do not make use of this header, except
 * if you're a KDEPrint developer. The API might change in the
 * future and binary compatibility might be broken.
 */
class KDEPRINT_MANAGEMENT_EXPORT KMJobViewer : public KMainWindow, public KMPrinterPage, public KPReloadObject
{
	Q_OBJECT
public:
	KMJobViewer(QWidget *parent = 0);
	~KMJobViewer();

	void setPrinter(const QString& prname);
	void setPrinter(KMPrinter *p);
	void refresh(bool reload = false);
	QString printer() const;
	bool isSticky() const;

Q_SIGNALS:
	void jobsShown(KMJobViewer*, bool hasJobs);
	void refreshClicked();
	void printerChanged(KMJobViewer*, const QString& prname);
	void viewerDestroyed(KMJobViewer*);

public Q_SLOTS:
	void pluginActionActivated(QAction*);

protected Q_SLOTS:
	void slotSelectionChanged();
	void slotHold();
	void slotResume();
	void slotRemove();
	void slotRestart();
	void slotRightClicked(QTreeWidgetItem*,const QPoint&,int);
	void slotMove(QAction*);
	void slotPrinterSelected(QAction*);
	void slotShowCompleted(bool);
	void slotRefresh();
	void slotClose();
	void slotShowMoveMenu();
	void slotShowPrinterMenu();
	void slotUserOnly(bool);
	void slotUserChanged();
	void slotConfigure();
	void slotDropped( QDropEvent*, QTreeWidgetItem* );

protected:
	void init();
	void updateJobs();
	void initActions();
	JobItem* findItem(const QString& uri);
	void jobSelection(QList<KMJob*>& l);
	void send(int cmd, const QString& name, const QString& arg = QString());
	void loadPrinters();
	void loadPluginActions();
	void removePluginActions();
	void reload();
	//void aboutToReload();
	void closeEvent(QCloseEvent*);
	void triggerRefresh();
	void addToManager();
	void removeFromManager();
	void buildPrinterMenu(QMenu *menu, bool use_all = false, bool use_specials = false);
	void updateCaption();
	void updateStatusBar();

private:
	QTreeWidget		*m_view;
	QList<KMJob*>		m_jobs;
	QList<JobItem*>		m_items;
	QMenu		*m_pop;
	QList<KMPrinter*>	m_printers;
	QString	m_prname;
	int	m_type;
	QString	m_username;
	QLineEdit	*m_userfield;
	QCheckBox	*m_stickybox;
	bool m_standalone;
};

inline QString KMJobViewer::printer() const
{ return m_prname; }

#endif
