/* This file is part of the KDE libraries
    Copyright (C) 1997 Martin Jones (mjones@kde.org)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
//-----------------------------------------------------------------------------
// KDE color selection combo box

// layout management added Oct 1997 by Mario Weilguni
// <mweilguni@sime.com>


#ifndef KCOLORCOMBO_H
#define KCOLORCOMBO_H

#include <qcombobox.h>

#include <kdelibs_export.h>

class KColorComboInternal;

/**
 * Combobox for colors.
 */
class KDEUI_EXPORT KColorCombo : public QComboBox
{
    Q_OBJECT
    Q_PROPERTY( QColor color READ color WRITE setColor )

public:
    /**
     * Constructs a color combo box.
     */
    KColorCombo( QWidget *parent );
    ~KColorCombo();

    /**
     * Selects the color @p col.
     */
    void setColor( const QColor &col );
    /**
     * Returns the currently selected color.
     **/
    QColor color() const;


    /**
     * Clear the color list and don't show it, till the next setColor() call
     **/
     void showEmptyList();

Q_SIGNALS:
    /**
     * Emitted when a new color box has been selected.
     */
    void activated( const QColor &col );
    /**
     * Emitted when a new item has been highlighted.
     */
    void highlighted( const QColor &col );

protected:
	virtual void resizeEvent( QResizeEvent *re );

private Q_SLOTS:
	void slotActivated( int index );
	void slotHighlighted( int index );

private:
	void addColors();

private:
	class KColorComboPrivate;
        friend class KColorComboPrivate;
	KColorComboPrivate *d;
        
        Q_DISABLE_COPY(KColorCombo)
};

#endif	// KCOLORCOMBO_H
