/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <kdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#ifndef KPRINTACTION_H
#define KPRINTACTION_H

#include <kdeprint_export.h>
#include <kactionmenu.h>

class KPrinter;
class KActionCollection;

class KDEPRINT_EXPORT KPrintAction : public KActionMenu
{
	Q_OBJECT
public:
	enum PrinterType { All, Regular, Specials };

	explicit KPrintAction(const QString& text, PrinterType type = All, QWidget *parentWidget = 0);
	KPrintAction(const KIcon& icon, const QString& text, PrinterType type = All, QWidget *parentWidget = 0);
	virtual ~KPrintAction();

	static KPrintAction* exportAll(QWidget *parentWidget = 0, KActionCollection *parent = 0, const char *name = 0);
	static KPrintAction* exportRegular(QWidget *parentWidget = 0, KActionCollection *parent = 0, const char *name = 0);
	static KPrintAction* exportSpecial(QWidget *parentWidget = 0, KActionCollection  *parent = 0, const char *name = 0);

Q_SIGNALS:
	void print(KPrinter*);

protected Q_SLOTS:
	void slotAboutToShow();
	void slotActivated(QAction*);

protected:
	void initialize(PrinterType type, QWidget *parentWidget);

private:
	class KPrintActionPrivate;
	KPrintActionPrivate* const d;
};

#endif
