/*
 *  This file is part of the KDE libraries
 *  Copyright (c) 2001 Michael Goffioul <kdeprint@swing.be>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License version 2 as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 **/

#include "cupsddialog.h"

#include <QtCore/QFile>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kapplication.h>
#include <kurl.h>

extern "C" int main(int argc, char *argv[])
{
    KCmdLineArgs::init(argc, argv, "cupsdconf", "cupsdconf4",
                       ki18n("A CUPS configuration tool"), "0.0.1",
                       ki18n("A CUPS configuration tool"));

    KCmdLineOptions options;
    options.add("+[file]", ki18n("Configuration file to load"));
    KCmdLineArgs::addCmdLineOptions(options);
    KApplication app;
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    KUrl configfile;
    if (args->count() > 0)
        CupsdDialog::configure(args->url(0).path());
    else
        CupsdDialog::configure();
    return (0);
}
