/* This file is part of Noatun

  Copyright 2001-2006 by Charles Samuels <charles@kde.org>
  Copyright 2003-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef N_APP_H
#define N_APP_H

#include <kuniqueapplication.h>

namespace Noatun
{
class Global; // forward decl
}

class GeneralPrefsPage;
class PluginSelectorPage;

/**
 * @brief Noatun Application class
 * @author Charles Samuels
 * @author Stefan Gehn
 * @version 3.0
 */
class NoatunApplication : public KUniqueApplication
{
Q_OBJECT
public:
	NoatunApplication();
	~NoatunApplication();

protected:
	virtual int newInstance();

private Q_SLOTS:
	void slotNewFrontend();

private:
	Noatun::Global     *mInstance;
	GeneralPrefsPage   *mGeneralPrefs;
	PluginSelectorPage *mPluginPrefs;
};

#endif // N_APP_H
