/* This file is part of Noatun

  Copyright 2000-2001 Neil Stevens <neil@qualityassistant.com>
  Copyright 2000-2003 Charles Samuels <charles@kde.org>
  Copyright 2003-2007 by Stefan Gehn <mETz81@web.de>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef PLUGINMODULE_H
#define PLUGINMODULE_H

#include "noatun/preferencespage.h"

#include <qmap.h>
#include <k3listview.h>

class Ui_PluginModuleWidget;
class KPluginInfo;

namespace Noatun
{
	class Plugin;
}

using namespace Noatun;


class PluginListItem : public Q3ListViewItem
{
public:
	PluginListItem(const KPluginInfo *info, bool isRadio, Q3ListView *parent);
	QString pluginCaption() const;
	const QString &pluginName() const;
	bool pluginEnabled() const;
	void setPluginEnabled(bool val);

private:
	void paintCell(QPainter *p, const QColorGroup &cg, int column, int width, int alignment);

private:
	QString mPluginName;
	bool    mPluginEnabled;
	bool    mIsRadio;
}; // class PluginListItem


/**
 * @todo Port to pure Qt4
 **/
class PluginSelectorPage : public PreferencesPage
{
Q_OBJECT
public:
	explicit PluginSelectorPage(Global *nInst);

public Q_SLOTS:
	virtual void save();
	virtual void load();
	virtual void defaults();

private:
	void updateSelectionFor(const QString &pluginName, const QStringList &interfaces, bool on);
	void fillList(K3ListView *lv, bool radio, QMap<QString, PluginListItem*> &dict, const QString &interfacename);
	void getChanged(QMap<QString, PluginListItem*> &dict, const QString &interfacename,
		QStringList &load, QStringList &unload);
	void clearPluginSelection(Q3ListView  *lv);

private Q_SLOTS:
	void slotDeselectPlugin(Plugin *plug);
	void slotSelectPlugin(Plugin *plug);

	void slotFrontendClicked(Q3ListViewItem *qli, const QPoint &point, int col);
	void slotPLClicked(Q3ListViewItem *qli, const QPoint &point, int col);
	void slotMultiSelClicked(Q3ListViewItem *qli, const QPoint &point, int col);

private:
	Global  *nInstance;
	bool     mChanged;
	bool     mUpdating;
	Ui_PluginModuleWidget *mWidget;
	QMap<QString, PluginListItem*> mPLDict, mUIDict, mVisDict, mOthersDict;
	QString mCurrentUI, mNewUI, mCurrentPL, mNewPL;
}; // class PluginSelectorPage

#endif // END PLUGINMODULE_H
