/* This file is part of Noatun

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#ifndef N_MAINWINDOW_H
#define N_MAINWINDOW_H

#include <kmainwindow.h>
#include <noatun_export.h>

namespace Noatun
{
class Plugin;
class NMainWindowPrivate;

/**
 * NMainWindow is mainly needed to ensure a common menu/toolbar layout so that
 * other plugins can plug actions into a noatun-mainwindow. It also handles
 * closing of mainwindows in case of noatun having a systray-icon.
 * NMainWindow is usually used by a plugin implementing a FrontendInterface but
 * can also be used by any other plugin that needs a mainwindow (better set
 * wantNoatunXML to false in this case).
 *
 * @brief  A specialized KMainWindow for Noatun plugins.
 * @author Stefan Gehn
 **/
class NOATUN_EXPORT NMainWindow : public KMainWindow
{
Q_OBJECT
public:
	/**
	 * Constructor
	 * @param plug          Plugin that owns this mainwindow
	 * @param isSkinned     set to true if your mainwindow is ownerdrawn. Menubar,
	 *                      toolbar etc. will remain hidden with this set
	 * @param wantNoatunXML set to true if you want to merge in noatun standard
	 *                      menu/toolbar/popup definitions, false otherwise.
	 *                      Defaults to true
	 * @param parent        The widget parent. This is usually 0 but it may also
	 *                      be the window group leader. In that case, the
	 *                      NMainWindow becomes sort of a secondary window.
	 * @param f             Widget flags
	 **/
	explicit NMainWindow(Plugin *plug, bool isSkinned = false,
		bool wantNoatunXML = true, QWidget* parent = 0, Qt::WindowFlags f = 0);

	virtual ~NMainWindow();

protected:
	/**
	 * Call KMainWindow setupGUI() if your Mainwindow uses normal KDE/QT widgets,
	 * otherwise use setXMLFile(). If you call it without any arguments it will
	 * simply give you access to the default Noatun popupmenu (name is
	 * "NoatunContextMenu"). You can then get a KPopupMenu representation with
	 * @code
	 * KPopupMenu *popup = static_cast<KPopupMenu *>(factory()->container("NoatunContextMenu",this));
	 * @endcode
	 * Check noatun.rc contents for other standard menu/toolbar/popup names.
	 **/
	virtual void setXMLFile(const QString &file = QString(), bool merge = false,
		bool setXMLDoc = true);

	/**
	 * Reimplemented setupGUI from KMainWindow.
	 * @note Never use createGUI(), use this method instead
	 **/
	void setupGUI(StandardWindowOptions options = Default,
		const QString &xmlfile = QString());

	/**
	 * Reimplemented for proper systray behaviour.
	 **/
	void closeEvent(QCloseEvent *e);

private:
	/**
	 * @todo Support hiding of dockwidgets
	 **/
	void updateSkin();

private:
	NMainWindowPrivate * const d;
}; // END class NMainWindow

} // END namespace Noatun
#endif // N_MAINWINDOW_H
