/* This file is part of Noatun

  Copyright 2005-2007 by Stefan Gehn <mETz81@web.de>
  Copyright 2006 by Charles Samuels <charles@kde.org>

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
    notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
    notice, this list of conditions and the following disclaimer in the
    documentation and/or other materials provided with the distribution.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
  OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include "noatun/preferencesdialog.h"
#include "noatun/preferencespage.h"
#include "noatun/plugin.h"
#include "noatun/pluginloader.h"
#include "noatun/global.h"

#include <kdebug.h>


namespace Noatun
{

class PreferencesDialogPrivate
{
public:
	QList< QPointer<PreferencesPage> > pages;
	QList< QPointer<PreferencesPage> > dirtyPages;
};


// -----------------------------------------------------------------------------


PreferencesDialog::PreferencesDialog(Global *nInst) : KPageDialog(),
	d(new PreferencesDialogPrivate)
{
	Q_ASSERT(nInst);

	setFaceType(KPageDialog::List);
	setButtons(KDialog::Ok | KDialog::Cancel | KDialog::Apply | KDialog::Default);
	setModal(false);
	enableButtonApply(false);

	connect(this, SIGNAL(applyClicked()), SLOT(saveDirtyPages()));
	connect(this, SIGNAL(okClicked())   , SLOT(saveDirtyPages()));
	connect(this, SIGNAL(defaultClicked()), SLOT(setDefaults()));

	//connect(nInst->pluginHandler(), SIGNAL(pluginLoaded(Plugin*)), SLOT(addPluginPage(Plugin *)));
	//connect(nInst->pluginHandler(), SIGNAL(pluginUnloaded(Plugin*)), SLOT(removePluginPage(Plugin *)));
}


PreferencesDialog::~PreferencesDialog()
{
	delete d;
}


void PreferencesDialog::show()
{
	kDebug(66666) << k_funcinfo << "showing noatun preferences dialog" << endl;
	if (!isVisible())
	{
		kDebug(66666) << k_funcinfo << "loading preferences for plugins" << endl;
		foreach(PreferencesPage *page, d->pages)
		{
			if (page)
				page->load();
		}
	}
	KPageDialog::show();
}


void PreferencesDialog::show(PreferencesPage *page)
{
	kDebug(66666) << k_funcinfo << endl;
	if (page)
		setCurrentPage(page);
	show();
}


void PreferencesDialog::addPreferencesPage(PreferencesPage *page)
{
	kDebug(66666) << k_funcinfo << endl;
	if (page)
	{
		d->pages.append(page);
		connect(page, SIGNAL(changed(bool)), SLOT(updateDirtyPages(bool)));
		addPage(page);
	}
}


void PreferencesDialog::removePreferencesPage(PreferencesPage *page)
{
	kDebug(66666) << k_funcinfo << endl;
	if (page)
	{
		d->pages.removeAll(page);
		d->dirtyPages.removeAll(page);
		disconnect(page, 0, this, 0);
		removePage(page);
	}
	enableButtonApply(!d->dirtyPages.isEmpty());
}


void PreferencesDialog::saveDirtyPages()
{
	kDebug(66666) << k_funcinfo << endl;
	foreach(PreferencesPage *page, d->dirtyPages)
	{
		if (page)
			page->save();
	}
	d->dirtyPages.clear();
	enableButtonApply(false);
}


void PreferencesDialog::setDefaults()
{
	kDebug(66666) << k_funcinfo << endl;
	foreach(QPointer<PreferencesPage> page, d->pages)
	{
		if (page)
			page->defaults();
	}
}


/*void PreferencesDialog::addPluginPage(Plugin *p)
{
	kDebug(66666) << k_funcinfo << "for " << p->pluginName() << endl;
	addPreferencesPage(p->preferencesPage());
}


void PreferencesDialog::removePluginPage(Plugin *p)
{
	kDebug(66666) << k_funcinfo << "for " << p->pluginName() << endl;
	removePreferencesPage(p->preferencesPage());
}*/


void PreferencesDialog::updateDirtyPages(bool isChanged)
{
	kDebug(66666) << k_funcinfo << endl;

	PreferencesPage *page = qobject_cast<PreferencesPage *>(sender());
	if (page)
	{
		if (isChanged)
		{
			if (!d->dirtyPages.contains(page))
				d->dirtyPages.append(page);
		}
		else
		{
			d->dirtyPages.removeAll(page);
		}
	}
	enableButtonApply(!d->dirtyPages.isEmpty());
}

} // namespace Noatun
#include "preferencesdialog.moc"
