#ifndef KEYZ_H
#define KEYZ_H

#include <noatun/cmodule.h>
#include <noatun/plugin.h>

class Keyz : public Noatun::Plugin
{
	Q_OBJECT

public:
	Keyz(const KComponentData &inst, Noatun::Global *glob, const char* name);
	~Keyz();
	
	static KGlobalAccel *accel() { return s_accel; }
	
	Noatun::Interface *getInterface(const QString &)
	{
		return 0;
	}

public Q_SLOTS:
	void slotVolumeUp();
	void slotVolumeDown();
	void slotMute();

	void slotForward();
	void slotBackward();
	void slotNextSection();
	void slotPrevSection();
	void slotCopyTitle();

private:
	static KGlobalAccel *s_accel;
	int preMuteVol;
};


class KeyzPrefs : public Noatun::PreferencesPage
{
	Q_OBJECT

public:
	KeyzPrefs( Noatun::Plugin *plug );
	virtual void save();
	virtual void load();
	virtual void defaults();

private:
	class KKeyChooser* m_chooser;

};

#endif // KEYZ_H
