/***************************************************************************
	helpers.cpp
	Just a few functions needed in several Kjofol-classes
	---------------------------------------------
	Maintainer: Charles Samuels <charles@kde.org>

 ***************************************************************************/

#ifndef KJHELPERS_CPP
#define KJHELPERS_CPP

inline static int grayRgb(QRgb r)
{
	return qGray(qRed(r), qGreen(r), qBlue(r));
}

inline static int isGray(QRgb r)
{
// this is more tolerant than the old version
// i.e. RGB 162 163 162 is treated as gray too
// too many broken skins around having such colors
	if ( (qRed(r)==qGreen(r)) || (qRed(r)+1==qGreen(r)) || (qRed(r)-1==qGreen(r)))
	{
		if ( (qRed(r)==qBlue(r)) || (qRed(r)+1==qBlue(r)) || (qRed(r)-1==qBlue(r)))
		{
			// looks a bit like gray, so return true
			return (1);
		}
	}
	// well, it's not gray
	return(0);
}


// only works little endian
// UPDATE: should work on both little and big endian now (haven't tested that!)
// this code is taken from the QT-docu and I hope that this example
// is one of the working ones ;)
inline static void setPixel1BPP(QImage &image, int x, int y, bool value)
{
	if (image.bitOrder() == QImage::LittleEndian)
	{
		if (value)
			*(image.scanLine(y) + (x >> 3)) |= 1 << (x & 7);
		else
			*(image.scanLine(y) + (x >> 3)) &= ~(1 << (x & 7));
	}
	else
	{
		if (value)
			*(image.scanLine(y) + (x >> 3)) |= 1 << (7-(x & 7));
		else
			*(image.scanLine(y) + (x >> 3)) &= ~(1 << (7-(x & 7)));
	}
}


inline static QBitmap KJgetMask(const QImage &_rect, register QRgb transparent = qRgb(255,0,255))
{
	QImage result(_rect.width(), _rect.height(), 1,2, QImage::LittleEndian);
#if QT_VERSION < 0x030300
	result.setColor(0, qRgb(0,0,0));  //TODO: maybe use Qt::color0 and Qt::color1
	result.setColor(1, qRgb(255,255,255));
#else
	result.setColor(1, qRgb(0,0,0));
	result.setColor(0, qRgb(255,255,255));
#endif

	for(int height=0;height<_rect.height(); height++)
	{
		for(int width=0; width<_rect.width(); width++)
			setPixel1BPP(result, width, height, _rect.pixel(width, height)!=transparent);
	}
	QBitmap bm;
	bm.convertFromImage(result);
	return bm;
}


#endif
