/***************************************************************************
	kjwidget.cpp  -  Base Class for all widgets
	--------------------------------------
	Maintainer: Stefan Gehn <sgehn@gmx.net>

 ***************************************************************************/

// local includes
#include "kjwidget.h"
//#include <kdebug.h>

// ugly static functions and stuff
#include "helpers.cpp"

#include <qpainter.h>

KJWidget::KJWidget(KJMainWindow *p) : mParent(p)
{
}


void KJWidget::repaint(bool me, const QRect &r, bool clear)
{
	QPainter p(parentWin());
	if (me)
		paint(&p, r.isValid() ? r : rect());
	else
		parentWin()->repaint(r.isValid() ? r : rect(), clear);
}


QString KJWidget::backgroundPressed(const QString &bmp) const
{
	QString ret;

	if(!bmp.isEmpty()) // play safe
	{
		// make absolutely sure the wanted backgroundimagepressedX line is there
		QString bgKey = "backgroundimagepressed" + bmp.mid(3);
		QStringList item = parser()[bgKey];
		if(item.count() >= 2)
			ret = item[1];
	}
	return ret;
}
