/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PHONON_GSTREAMER_ABSTRACTVIDEOOUTPUT_H
#define PHONON_GSTREAMER_ABSTRACTVIDEOOUTPUT_H

#include <phonon/videoframe.h>

namespace Phonon
{
namespace GStreamer
{

class AbstractVideoOutput
{
    public:
        virtual ~AbstractVideoOutput() {}

        virtual void processFrame(Phonon::VideoFrame &frame) = 0;
        virtual void *internal1(void * = 0) { return 0; }
};

}} //namespace Phonon::GStreamer

Q_DECLARE_INTERFACE(Phonon::GStreamer::AbstractVideoOutput, "org.kde.Phonon.GStreamer.AbstractVideoOutput/0.1")

#endif // PHONON_GSTREAMER_ABSTRACTVIDEOOUTPUT_H
// vim: sw=4 ts=4 noet
