/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PHONON_GSTREAMER_AUDIOOUTPUT_H
#define PHONON_GSTREAMER_AUDIOOUTPUT_H

#include "abstractaudiooutput.h"

#include "qbtgstreamer/qbtgstreamerpad.h"
#include "qbtgstreamer/qbtgstreamerelement.h"
#include "qbtgstreamer/qbtgstreamerghostpad.h"
#include "pipeline.h"

#include <QFile>
#include <phonon/audiooutputinterface.h>

namespace Phonon
{
namespace GStreamer
{
    class AudioOutputPrivate
    {
        public:
            AudioOutputPrivate()
                : pipeline(0),
                  element(0),
                  sink(0),
                  adder(0)
            {
                setup();
            }

            QbtGStreamerGhostPad *requestSinkPad();
            void releaseSinkPad(QbtGStreamerGhostPad *pad);

            bool setup();

            QbtGStreamerElement *getElement();

            Pipeline *pipeline;

            QbtGStreamerBin *element;
    
            QbtGStreamerElement *sink;
            QbtGStreamerElement *adder;
    };

    class AudioOutput : public AbstractAudioOutput, public AudioOutputInterface
    {
        Q_OBJECT
        Q_INTERFACES(Phonon::AudioOutputInterface)

        friend class AudioOutputPrivate;

        public:
            AudioOutput (QObject *parent);
            ~AudioOutput();

            // Attributes Getters:
            float volume() const;
            int outputDevice() const;

            // Attributes Setters:
            void setVolume(float newVolume);
            bool setOutputDevice(int newDevice);

            QbtGStreamerGhostPad *requestSinkPad();
            void releaseSinkPad(QbtGStreamerGhostPad *pad);

        Q_SIGNALS:
            void volumeChanged(float newVolume);
            void audioDeviceFailed();

        private:
            float m_volume;
            int m_device;

            AudioOutputPrivate *d;
    };
}} //namespace Phonon::GStreamer

// vim: sw=4 ts=4 tw=80 et
#endif // PHONON_GSTREAMER_AUDIOOUTPUT_H
