/*  This file is part of the KDE project
    Copyright (C) 2006 Matthias Kretz <kretz@kde.org>
    Copyright (C) 2006-2007 Tim Beaulen <tbscope@gmail.com>

    Based on code by Fluendo:
    Copyright (C) 2006 Wim Taymans <wim@fluendo.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef PHONON_GSTREAMER_CONTROLITEM_H
#define PHONON_GSTREAMER_CONTROLITEM_H

#include <QGraphicsView>
#include <QPainter>
#include <QWidget>
#include <QStyleOptionGraphicsItem>
#include <QGraphicsItem>
#include <QtGlobal>
#include <QRect>
#include <QRectF>
#include <QGraphicsSceneMouseEvent>
#include <QPixmap>
#include <QString>

namespace Phonon
{
namespace GStreamer
{
    class ControlItem : public QGraphicsItem
    {
        public:
            ControlItem(QGraphicsView *control);
            QRectF boundingRect() const;
            void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *widget);

            void mousePressEvent(QGraphicsSceneMouseEvent *event);

        private:
            QPixmap cached(const QString &img);
            bool m_paused;
            QRect m_playRect;
            QRect m_saveRect;
    };
}} // Phonon::GStreamer

#endif
