/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERTYPEFINDELEMENT
#define QBTGSTREAMERTYPEFINDELEMENT

#include "../qbtgstreamerelement.h"
#include "../qbtgstreamerdatapointer.h"
#include "../qbtgstreamercapabilities.h"

#include <gst/gst.h>

class QbtGStreamerTypeFindElement : public QbtGStreamerElement
{
Q_OBJECT
public:
    QbtGStreamerTypeFindElement();
    QbtGStreamerTypeFindElement(const QbtGStreamerTypeFindElement&);
    QbtGStreamerTypeFindElement& operator= (const QbtGStreamerTypeFindElement&);
    QbtGStreamerTypeFindElement(QbtGStreamerElement*);
    ~QbtGStreamerTypeFindElement();

    //QbtGStreamerCaps* caps();

signals:
    void haveType(QbtGStreamerTypeFindElement* element, uint probability, QbtGStreamerCapabilities* caps, QbtGStreamerDataPointer* data);

private:
    static QbtGStreamerTypeFindElement* s_instance;
    static QbtGStreamerTypeFindElement* instance() { return s_instance; }
    static void have_type(GstElement *typefind, guint probability, GstCaps *caps, gpointer user_data);
};

#endif
