/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamer.h"

#include <QString>
#include <QtDebug>

QbtGStreamer::QbtGStreamer()
{
}

QbtGStreamer::~QbtGStreamer()
{
}

void QbtGStreamer::init(int argc, char *argv[])
{
    gst_init(&argc, &argv);
}

bool QbtGStreamer::initCheck(int argc, char *argv[])
{
    //TODO: also get the error when the init fails!
    GError **error;
    return gst_init_check(&argc, &argv, error);
}

void QbtGStreamer::deInit()
{
    gst_deinit();
}

void QbtGStreamer::version(uint &major, uint &minor, uint &micro, uint &nano)
{
    gst_version(&major, &minor, &micro, &nano);
}

QString QbtGStreamer::versionString()
{
    QString strVersion(gst_version_string());
    return strVersion;
}
