/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerelementfactory.h"
#include "qbtgstreamercallbackmanager.h"

#include <QtDebug>

QbtGStreamerElementFactory::QbtGStreamerElementFactory()
{
}

QbtGStreamerElementFactory::~QbtGStreamerElementFactory()
{
}

QbtGStreamerElement *QbtGStreamerElementFactory::makeElement(const QString& factoryName, const QString& name)
{
    QbtGStreamerElement *element = new QbtGStreamerElement;

    GstElement *gstElement;

    if (name.isEmpty())
        gstElement = gst_element_factory_make(factoryName.toLocal8Bit().data(), NULL);
    else
        gstElement = gst_element_factory_make(factoryName.toLocal8Bit().data(), name.toLocal8Bit().data());

    if(!gstElement)
        return 0;

    element->setGstElement(gstElement);
    QbtGStreamerCallbackManager::Instance()->elements.append(element);

    //qDebug() << "Added new item to callback manager list. List count:" << QbtGStreamerCallbackManager::Instance()->m_elements.count();

    return element;
}

QString QbtGStreamerElementFactory::klass()
{
    return QString(gst_element_factory_get_klass(m_factory));
}

QString QbtGStreamerElementFactory::longName()
{
    return QString(gst_element_factory_get_longname(m_factory));
}

QString QbtGStreamerElementFactory::description()
{
    return QString(gst_element_factory_get_description(m_factory));
}

QString QbtGStreamerElementFactory::author()
{
    return QString(gst_element_factory_get_author(m_factory));
}

QStringList QbtGStreamerElementFactory::uriProtocols()
{
    qDebug() << "QbtGStreamer debug: QStringList QbtGStreamerElementFactory::uriProtocols()";

    if (!m_factory)
        return QStringList();

    QStringList returnList;
    gchar **protocols;

    protocols = gst_element_factory_get_uri_protocols(m_factory);
    if (protocols) {
        gchar *protocol;
        while ((protocol = *(protocols++)) != NULL) {
            qDebug() << "QbtGStreamer debug: item";
            QString s(protocol);
            returnList << s;
        }
    }

    return returnList;
}

void QbtGStreamerElementFactory::setGstElementFactory(GstElementFactory* factory)
{
    m_factory = factory;
}

bool QbtGStreamerElementFactory::fromPluginFeature(QbtGStreamerPluginFeature* feature)
{
    if(!feature->isElementFactory())
        return false;

    m_factory = GST_ELEMENT_FACTORY(feature->gstPluginFeature());
    return true;
}

GstElementFactory* QbtGStreamerElementFactory::gstElementFactory()
{
    return m_factory;
}

/*QList<QbtGStreamerElement*> QbtGStreamerElementFactory::elements()
{
    return m_elements;
}*/
