/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERERROR
#define QBTGSTREAMERERROR

#include <QString>
#include "qbtgstreamer_export.h"

#include <gst/gst.h>

enum QbtGStreamerErrorDomain
{
    QbtGStreamerErrorCore,
    QbtGStreamerErrorLibrary,
    QbtGStreamerErrorResource,
    QbtGStreamerErrorStream,
    QbtGStreamerErrorSystem
};

enum QbtGStreamerErrorResource
{
    QbtGStreamerErrorResourceFailed = 1,
    QbtGStreamerErrorResourceTooLazy,
    QbtGStreamerErrorResourceNotFound,
    QbtGStreamerErrorResourceBusy,
    QbtGStreamerErrorResourceOpenRead,
    QbtGStreamerErrorResourceOpenWrite,
    QbtGStreamerErrorResourceOpenReadWrite,
    QbtGStreamerErrorResourceClose,
    QbtGStreamerErrorResourceRead,
    QbtGStreamerErrorResourceWrite,
    QbtGStreamerErrorResourceSeek,
    QbtGStreamerErrorResourceSync,
    QbtGStreamerErrorResourceSettings,
    QbtGStreamerErrorResourceNoSpaceLeft,
    QbtGStreamerErrorResourceNumErrors
};

class QBTGSTREAMER_EXPORT QbtGStreamerError
{
public:
    QbtGStreamerError();

    QbtGStreamerErrorDomain domain();
    int code();

    void setGError(GError *error);
    GError *gError();

private:
    GError *m_error;
};

#endif
