/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef QBTGSTREAMERGHOSTPAD
#define QBTGSTREAMERGHOSTPAD

#include "qbtgstreamer_export.h"
#include <gst/gst.h>

#include "qbtgstreamerpad.h"

#include <QString>

//Note, GhostPad is actually a subclass of ProxyPad.
//Proxypad however is a private class.
//GhostPad is a pad though, so subclass qbtgstreamerpad while in the background proxypad is being used.
//In short, proxypad doesn't need to be wrapped!
class QBTGSTREAMER_EXPORT QbtGStreamerGhostPad : public QbtGStreamerPad
{
public:
    QbtGStreamerGhostPad(const QString &name, QbtGStreamerPad *target);

    QbtGStreamerPad *target();
};

#endif
