/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerregistry.h"

#include <QtDebug>

QbtGStreamerRegistry::QbtGStreamerRegistry()
{
    //qDebug() << "Registry class created:" << this;
}

QbtGStreamerRegistry::~QbtGStreamerRegistry()
{
}

QbtGStreamerRegistry* QbtGStreamerRegistry::defaultRegistry()
{
    QbtGStreamerRegistry* def = new QbtGStreamerDefaultRegistry;

    def->setGstRegistry(gst_registry_get_default());

    //qDebug() << "QbtGStreamerRegistry* QbtGStreamerRegistry::defaultRegistry() called: Class:" << def;
    //qDebug() << "Returning new registry with GstRegistry =" << def->gstRegistry();

    return def;
}

void QbtGStreamerRegistry::makeDefault()
{
    m_registry = gst_registry_get_default();
}

QList<QbtGStreamerPluginFeature*> QbtGStreamerRegistry::featureList()
{
    QList<QbtGStreamerPluginFeature*> returnList;

    GList* list;
    const GList *item;

    if(!m_registry)
        return QList<QbtGStreamerPluginFeature*>();

    list = gst_registry_feature_filter(m_registry, /*(GstPluginFeatureFilter)*/cb_featureFilter, FALSE, this);
    for(item = list; item != NULL; item = item->next) {
        QbtGStreamerPluginFeature* btPluginFeature = new QbtGStreamerPluginFeature;
        btPluginFeature->setGstPluginFeature(GST_PLUGIN_FEATURE(item->data));
        returnList.append(btPluginFeature);
    }

    return returnList;
}

QbtGStreamerPluginFeature* QbtGStreamerRegistry::featureListFirst()
{
    // Not implemented yet.
    return new QbtGStreamerPluginFeature;
}

/* Reimplement to create a filter */
bool QbtGStreamerDefaultRegistry::featureFilter(QbtGStreamerPluginFeature* feature, QbtGStreamerDataPointer* data)
{
    Q_UNUSED(feature)
    Q_UNUSED(data)

    //qDebug() << "Default featureFilter called (" << this << ")";

    return true;
}

void QbtGStreamerRegistry::setGstRegistry(GstRegistry* registry)
{
    m_registry = registry;
}

GstRegistry* QbtGStreamerRegistry::gstRegistry()
{
    return m_registry;
}

gboolean QbtGStreamerRegistry::cb_featureFilter(GstPluginFeature* feature, gpointer data)
{
    QbtGStreamerPluginFeature* f = new QbtGStreamerPluginFeature;
    QbtGStreamerDataPointer* d = new QbtGStreamerDataPointer;

    f->setGstPluginFeature(feature);
    d->setGPointer(data);

    //qDebug() << "QbtGStreamerRegistry class =" << data;

    //qDebug() << "Calling:" << static_cast<QbtGStreamerRegistry*>(data) << "->featureFilter(f,d);";
    return static_cast<QbtGStreamerRegistry*>(data)->featureFilter(f,d);
}
