/*  This file is part of the QbtGStreamer project, a Qt GStreamer Wrapper
    Copyright (C) 2006 Tim Beaulen <tbscope@gmail.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License version 2 as published by the Free Software Foundation.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "qbtgstreamerstructure.h"

QbtGStreamerStructure::QbtGStreamerStructure()
{
}

QbtGStreamerStructure::QbtGStreamerStructure(const QString& name)
{
    Q_UNUSED(name)
}

QString QbtGStreamerStructure::value(const QString& fieldName)
{
    const GValue* gValue = gst_structure_get_value(m_structure, fieldName.toLocal8Bit().data());

    QString contents =  QString(g_strdup_value_contents(gValue));

    return contents;
}

void QbtGStreamerStructure::setGstStructure(GstStructure *structure)
{
    m_structure = structure;
}

GstStructure *QbtGStreamerStructure::gstStructure()
{
    return m_structure;
}
