/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */

#ifndef Phonon_NMM_BACKEND_H
#define Phonon_NMM_BACKEND_H

#include <QStringList>
#include <QObject>
#include <nmm/base/registry/NodeDescription.hpp>
#include <phonon/objectdescription.h>
#include <phonon/backendinterface.h>

namespace NMM
{
	class ClientRegistry;
	class NMMApplication;
}
namespace Phonon
{
namespace nmm
{

	class Backend : public QObject, public BackendInterface
	{
		Q_OBJECT
        Q_INTERFACES(Phonon::BackendInterface)
		public:
			Backend( QObject* parent, const QStringList& args );
			~Backend();

            QObject* createObject0(BackendInterface::Class0, QObject *parent);
            QObject* createObject1(BackendInterface::Class1, QObject *parent, QVariant arg1);

			Q_INVOKABLE bool supportsVideo() const;
			Q_INVOKABLE bool supportsOSD() const;
			Q_INVOKABLE bool supportsFourcc( quint32 fourcc ) const;
			Q_INVOKABLE bool supportsSubtitles() const;

			Q_INVOKABLE void freeSoundcardDevices();

            QSet<int> objectDescriptionIndexes(ObjectDescriptionType) const;
            QHash<QByteArray, QVariant> objectDescriptionProperties(ObjectDescriptionType, int) const;

		public slots:
			QStringList knownMimeTypes() const;
			const char* uiLibrary() const;
			//const char* uiSymbol() const;

		public:
			NMM::ClientRegistry& getRegistry();
			NMM::NMMApplication* nmmApplication() { return m_app; }
            NMM::INode* requestNode(NMM::NodeDescription);

		private:
			NMM::NMMApplication* m_app;
			bool m_initialized; //indicates whether the nmm stuff has been properly initialized

			QStringList m_supportedMimeTypes;
			QStringList m_audioEffects, m_videoEffects;
	};


}} // namespace Phonon::nmm

#endif
// vim: sw=4 ts=4 tw=80 et
