/* NMM - Network-Integrated Multimedia Middleware
 *
 * Copyright (C) 2006
 *               Motama GmbH, Saarbruecken, Germany
 *
 * Maintainer: Bernhard Fuchshumer <fub@motama.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2
 * of the License only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 */
#include "videopath.h"
#include "videoeffect.h"
#include "abstractvideooutput.h"
#include "nmm/base/graph/GraphHandler.hpp"
#include <kdebug.h>

namespace Phonon
{
namespace nmm
{

VideoPath::VideoPath( QObject* parent )
	: QObject( parent )
	, m_branchId(-1)
    , m_sink(0)
{
}

VideoPath::~VideoPath()
{
}

bool VideoPath::addOutput( QObject* videoOutput )
{
	Q_ASSERT( videoOutput );
	Q_ASSERT( !m_outputs.contains( videoOutput ) );
	m_outputs.append( videoOutput );
	return true;
}

bool VideoPath::removeOutput( QObject* videoOutput )
{
	Q_ASSERT( videoOutput );
	Q_ASSERT( m_outputs.removeAll( videoOutput ) == 1 );
	return true;
}

bool VideoPath::insertEffect( QObject* newEffect, QObject* insertBefore )
{
	Q_ASSERT( newEffect );
	VideoEffect* ae = qobject_cast<VideoEffect*>( newEffect );
	Q_ASSERT( ae );
	VideoEffect* before = 0;
	if( insertBefore )
	{
		before = qobject_cast<VideoEffect*>( insertBefore );
		Q_ASSERT( before );
		if( !m_effects.contains( before ) )
			return false;
		m_effects.insert( m_effects.indexOf( before ), ae );
	}
	else
		m_effects.append( ae );

	return true;
}

bool VideoPath::removeEffect( QObject* effect )
{
	Q_ASSERT( effect );
	VideoEffect* ae = qobject_cast<VideoEffect*>( effect );
	Q_ASSERT( ae );
	if( m_effects.removeAll( ae ) > 0 )
		return true;
	return false;
}

void VideoPath::setBranchId(int id)
{
	m_branchId = id;
}

int VideoPath::getBranchId()
{
	return m_branchId;
}

bool VideoPath::insertInto(NMM::GraphHandler* graph)
{
    // WARNING we don't have VideoOutput objects... why?
    // request the sink here
    
	try
	{
		int channel = 0; //default channel
        NMM::NodeDescription playback_nd("XDisplayNode");
        
		m_branchId = graph->addBranch(graph->getVideoStreamName(channel), playback_nd);

	}
	catch(...)
	{
		//TODO print some error msg
		return false;
	}
    return true;
}

}}

#include "videopath.moc"
// vim: sw=4 ts=4 tw=80 noet
