/*
 * knewstickerstub.cpp
 *
 *
 * Copyright (c) 2000, 2001 Frerich Raabe <raabe@kde.org>
 *
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 *
 */

#include <kaboutdata.h>
#include <kapplication.h>
#include <kcmdlineargs.h>
#include <kdebug.h>
#include <QtDBus>


#include "configaccess.h"



static const char name[] = "knewstickerstub";
static const char verbname[] = I18N_NOOP("KNewsTickerStub");
static const char version[] = "0.3";
static const char description[] = I18N_NOOP("A frontend to the KNewsTicker configuration");
static const char copyright[] = I18N_NOOP("(c)2000, 2001 Frerich Raabe");

int main(int argc, char **argv)
{
    KLocale::setMainCatalog("knewsticker");

    KAboutData aboutData(name, 0, ki18n(verbname), version, ki18n(description),
                         KAboutData::License_BSD, ki18n(copyright));
    aboutData.addAuthor(ki18n("Frerich Raabe"), ki18n("Author"), "raabe@kde.org");

    KCmdLineArgs::init(argc, argv, &aboutData);

    KCmdLineOptions options;
    options.add("a");
    options.add("addrdf <url>", ki18n("Add the RDF/RSS file referenced by <url>"));
    KCmdLineArgs::addCmdLineOptions(options);
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    KApplication app(false);
    KConfig cfg(QLatin1String( "knewsticker_panelappletrc"), KConfig::NoGlobals );
    ConfigAccess configFrontend(&cfg);

    if (args->isSet("addrdf")) {
        QStringList newsSources = configFrontend.newsSources();

        // TODO: Use the "Suggest" functionality from addnewssourcedlgimpl.cpp here.
        QString name = i18n("Unknown");
        if (newsSources.contains(name))
            for (unsigned int i = 0; ; i++)
                if (!newsSources.contains(i18n("Unknown %1", i))) {
                    name = i18n("Unknown %1", i);
                    break;
                }

        newsSources += name;

        QString sourceFile = QString(args->getOption("addrdf"));
        configFrontend.setNewsSource(NewsSourceBase::Data(name, sourceFile));
        configFrontend.setNewsSources(newsSources);
        QDBusInterface newsticker("org.kde.knewsticker", "/KNewsTicker", "org.kde.knewsticker.KNewsTicker");
        newsticker.call("reparseConfig");

    }

    args->clear();

    return 0;
}
