/*
 * kcmkiolan.cpp
 *
 * Copyright (c) 2000 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "kcmkiolan.h"

#include <qcheckbox.h>
#include <qlayout.h>
#include <qlineedit.h>

#include <qlabel.h>
#include <q3groupbox.h>
//Added by qt3to4:
#include <QVBoxLayout>

#include <klocale.h>
#include <kdebug.h>
#include <kdialog.h>
#include <kvbox.h>

IOSlaveSettings::IOSlaveSettings(const QString& config, const KComponentData &inst,QWidget *parent)
:KCModule(inst,parent)
,m_config(config)
{
   QVBoxLayout *layout = new QVBoxLayout(this);
   layout->setSpacing(KDialog::spacingHint());
   layout->setMargin(KDialog::marginHint());

   Q3GroupBox* group=new Q3GroupBox(1, Qt::Horizontal, i18n("Show Links for Following Services"), this);
   layout->addWidget(group);

   m_ftpSettings=new PortSettingsBar(i18n("FTP (TCP, port 21): "), group);
   m_httpSettings=new PortSettingsBar(i18n("HTTP (TCP, port 80): "),group);
   m_nfsSettings=new PortSettingsBar(i18n("NFS (TCP, port 2049): "),group);
   m_smbSettings=new PortSettingsBar(i18n("Windows shares (TCP, ports 445 and 139):"),group);
   m_fishSettings=new PortSettingsBar(i18n("Secure Shell/Fish (TCP, port 22): "),group);
   m_shortHostnames = new QCheckBox(i18n("Show &short hostnames (without domain suffix)"),this);
   layout->addWidget(m_shortHostnames);

   KHBox *hbox=new KHBox(this);
   layout->addWidget(hbox);
   QLabel *label=new QLabel(i18n("Default LISa server host: "), hbox);
   m_defaultLisaHostLe=new QLineEdit(hbox);
   label->setBuddy(m_defaultLisaHostLe);

   QWidget *w=new QWidget(this);
   layout->addWidget(w);
   layout->setStretchFactor(m_ftpSettings,0);
   layout->setStretchFactor(m_httpSettings,0);
   layout->setStretchFactor(m_nfsSettings,0);
   layout->setStretchFactor(m_smbSettings,0);
   layout->setStretchFactor(m_shortHostnames,0);
   layout->setStretchFactor(hbox,0);
   layout->setStretchFactor(w,1);

   connect(m_ftpSettings,SIGNAL(changed()),this,SIGNAL(changed()));
   connect(m_httpSettings,SIGNAL(changed()),this,SIGNAL(changed()));
   connect(m_nfsSettings,SIGNAL(changed()),this,SIGNAL(changed()));
   connect(m_smbSettings,SIGNAL(changed()),this,SIGNAL(changed()));
   connect(m_fishSettings,SIGNAL(changed()),this,SIGNAL(changed()));
   connect(m_shortHostnames,SIGNAL(clicked()),this,SIGNAL(changed()));
   connect(m_defaultLisaHostLe, SIGNAL(textChanged(const QString&)),this,SIGNAL(changed()));
}

void IOSlaveSettings::load()
{
   kDebug()<<"IOSlaveSettings::load()";
   m_ftpSettings->setChecked(m_config.group("").readEntry("Support_FTP", PORTSETTINGS_CHECK));
   m_httpSettings->setChecked(m_config.group("").readEntry("Support_HTTP", PORTSETTINGS_CHECK));
   m_nfsSettings->setChecked(m_config.group("").readEntry("Support_NFS", PORTSETTINGS_CHECK));
   m_smbSettings->setChecked(m_config.group("").readEntry("Support_SMB", PORTSETTINGS_CHECK));
   m_fishSettings->setChecked(m_config.group("").readEntry("Support_FISH", PORTSETTINGS_CHECK));
   m_shortHostnames->setChecked(m_config.group("").readEntry("ShowShortHostnames",false));
//   m_rlanSidebar->setChecked(m_config.group("").readEntry("sidebarURL", "lan:/") == "rlan:/" ? true : false );
   m_defaultLisaHostLe->setText(m_config.group("").readEntry("DefaultLisaHost", "localhost"));
}

void IOSlaveSettings::save()
{
   kDebug()<<"IOSlaveSettings::save()";
   m_config.group("").writeEntry("AlreadyConfigured",true);
   m_config.group("").writeEntry("Support_FTP", m_ftpSettings->selected());
   m_config.group("").writeEntry("Support_HTTP", m_httpSettings->selected());
   m_config.group("").writeEntry("Support_NFS", m_nfsSettings->selected());
   m_config.group("").writeEntry("Support_SMB", m_smbSettings->selected());
   m_config.group("").writeEntry("Support_FISH", m_fishSettings->selected());
   m_config.group("").writeEntry("ShowShortHostnames",m_shortHostnames->isChecked());
//   m_config.group("").writeEntry("sidebarURL", m_rlanSidebar->isChecked() ? "rlan:/" : "lan:/");
   m_config.group("").writeEntry("DefaultLisaHost", m_defaultLisaHostLe->text());

   m_config.sync();
}

#include "kcmkiolan.moc"

