/*
 * portsettingsbar.cpp
 *
 * Copyright (c) 2000, 2005 Alexander Neundorf <neundorf@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "portsettingsbar.h"
#include <klocale.h>

#include <qlabel.h>
#include <kvbox.h>

PortSettingsBar::PortSettingsBar(const QString& title, QWidget *parent)
:KHBox(parent)
{
   QLabel* label=new QLabel(title, this);
   m_box=new QComboBox(this);
   label->setBuddy(m_box);

   m_box->addItem(i18n("Check Availability"));
   m_box->addItem(i18n("Always"));
   m_box->addItem(i18n("Never"));

   connect(m_box,SIGNAL(activated(int)),this,SIGNAL(changed()));
}

int PortSettingsBar::selected() const
{
   return m_box->currentIndex();
}

void PortSettingsBar::setChecked(int what)
{
   m_box->setCurrentIndex(what);
}

#include "portsettingsbar.moc"

