/* Copyright (C) 2002 Mickael Marchand <marchand@kde.org>

	 This program is free software; you can redistribute it and/or
	 modify it under the terms of the GNU General Public
	 License as published by the Free Software Foundation; either
	 version 2 of the License, or (at your option) any later version.

	 This program is distributed in the hope that it will be useful,
	 but WITHOUT ANY WARRANTY; without even the implied warranty of
	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	 General Public License for more details.

	 You should have received a copy of the GNU General Public License
	 along with this program; see the file COPYING.  If not, write to
	 the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
	 Boston, MA 02111-1307, USA.
	 */

#include <kapplication.h>
#include <klocale.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include "xvim_win.h"

static const KCmdLineOptions options[] =
{
	KCmdLineLastOption
};

int main( int argc, char ** argv )
{
  KAboutData aboutData( "xvim", I18N_NOOP("XVIM"), "0.1", I18N_NOOP( "A Vim remote command tool" ), 
			KAboutData::License_GPL, "(c) 2002, Mickael Marchand");
  aboutData.addAuthor("Mickael Marchand",0, "marchand@kde.org");
  KCmdLineArgs::init( argc, argv, &aboutData );
  KCmdLineArgs::addCmdLineOptions( options );

  KApplication a;
	XVim_Win *xw = new XVim_Win();
	xw->resize(100,300);
	a.setMainWidget(xw);
	xw->show();
  return a.exec();
}
