// KDat - a tar-based DAT archiver
// Copyright (C) 1998-2000  Sean Vyain, svyain@mail.tds.net
// Copyright (C) 2001-2002  Lawrence Widman, kdat@cardiothink.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#ifndef _OptionsDlg_h_
#define _OptionsDlg_h_

#include <qdialog.h>

class QCheckBox;
class QComboBox;
class QLineEdit;
class KIntNumInput;
class QPushButton;
/**
 * @short Display/edit user preferences.
 */
class OptionsDlg : public QDialog {
    Q_OBJECT
    KIntNumInput* _defaultTapeSize;
    QComboBox* _defaultTapeSizeUnits;
    KIntNumInput* _tapeBlockSize;
    QLineEdit* _tapeDevice;
    QLineEdit* _tarCommand;
    QCheckBox* _loadOnMount;
    QCheckBox* _lockOnMount;
    QCheckBox* _ejectOnUnmount;
    QCheckBox* _variableBlockSize;
private slots:
    void slotBrowseTapeDevice();
    void slotBrowseTarCommand();
    void slotOK();
    void slotApply();
    void slotCancel();
    void slotChanged();
public:
    /**
     * Create a new options dialog.
     *
     * @param parent The parent widget of the dialog.
     * @param name   The name of the dialog.
     */
    OptionsDlg( QWidget* parent = 0, const char* name = 0 );

    /**
     * Destroy the options dialog.
     */
    ~OptionsDlg();
private:
    bool configChanged;
    QPushButton* apply;
};

#endif
