/***************************************************************************
                            kde_KLibLoader.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KLIBLOADER
#define KDE_KLIBLOADER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KLibLoader allows you to load libraries dynamically at runtime.
 Dependent libraries are loaded automatically.

 KLibLoader follows the singleton pattern. You can not create multiple
 instances. Use @ref #self() to get a pointer to the loader.

 @author Torben Weis <weis@kde.org>
 
 @short *
 The KLibLoader allows you to load libraries dynamically at runtime.
*/

/** *
 You should NEVER destruct an instance of KLibLoader
 until you know what you are doing. This will release
 the loaded libraries.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_del_KLibLoader( kde_KLibLoader* p );

/** *
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.

 This is a convenience function that returns the factory immediately

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)

*/
kde_KLibFactory* kde_KLibLoader_factory(kde_KLibLoader* instPointer,char* libname);

/** *
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)

*/
kde_KLibrary* kde_KLibLoader_library(kde_KLibLoader* instPointer,char* libname);

/** *
 Loads and initializes a library. Loading a library multiple times is
 handled gracefully.   The library is loaded such that the symbols are
 globally accessible so libraries with dependencies can be loaded
 sequentially.

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)

*/
kde_KLibrary* kde_KLibLoader_globalLibrary(kde_KLibLoader* instPointer,char* name);
qt_QString * kde_KLibLoader_lastErrorMessage(kde_KLibLoader* instPointer);

/** *
 Unloads the library with the given name.

                 You can, however, give a library name ending in ".so"
                 (or whatever is used on your platform), and the library
                 will be loaded without resolving dependencies. USE WITH CARE :)
     
*/
void kde_KLibLoader_unloadLibrary(kde_KLibLoader* instPointer,char* libname);

/** *
 Returns a pointer to the factory. Use this function to get an instance
 of KLibLoader.

*/
kde_KLibLoader* kde_KLibLoader_self( );

/** *

 Internal Method, called by the KApplication destructor.
 Do not call it.
 This is what makes it possible to rely on ~KLibFactory
 being called in all cases, whether the library is unloaded
 while the application is running or when exiting.
     
*/
void kde_KLibLoader_cleanUp( );

/** *
 Helper method which looks for a library in the standard paths
 ("module" and "lib" resources).
 Made public for code that doesn't use KLibLoader itself, but still
 wants to open modules.

*/
qt_QString * kde_KLibLoader_findLibrary( char* name, kde_KInstance* instance);
kde_KLibLoader * kde_new_KLibLoader(qt_QObject * parent, char* name);
void kde_KLibLoader_virtual_hook(kde_KLibLoader* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
