/***************************************************************************
                            kde_KSSL.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSSL
#define KDE_KSSL

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

#ifdef __cplusplus
extern   "C" {
#endif
kde_KSSL * kde_new_KSSL(int init);
void kde_del_KSSL( kde_KSSL* p );
int kde_KSSL_initialize(kde_KSSL* instPointer);

/** *
 This is used for apps which do STARTTLS or something similar.
 It creates a TLS method regardless of the user's settings.
   
*/
int kde_KSSL_TLSInit(kde_KSSL* instPointer);
void kde_KSSL_close(kde_KSSL* instPointer);
int kde_KSSL_reInitialize(kde_KSSL* instPointer);
int kde_KSSL_reconfig(kde_KSSL* instPointer);
void kde_KSSL_setAutoReconfig(kde_KSSL* instPointer,int ar);

/** *
 This will reseed the PRNG with the EGD if the EGD is configured and
 enabled.  You don't need to call this yourself normally.
   
*/
int kde_KSSL_seedWithEGD(kde_KSSL* instPointer);

/** *
 Set a new KSSLSettings instance as the settings.
 This deletes the current instance of KSSLSettings.
   
*/
int kde_KSSL_setSettings(kde_KSSL* instPointer,kde_KSSLSettings* settings);

/** *

*/
kde_KSSLSettings* kde_KSSL_settings(kde_KSSL* instPointer);

/** *

*/
int kde_KSSL_setClientCertificate(kde_KSSL* instPointer,kde_KSSLPKCS12* pkcs);

/** *
 Set the status of the connection with respect to proxies.
 realIP is the IP address of the host you're connecting to
 realPort is the port of the host you're connecting to
 proxy is the IP or hostname of the proxy server
   
*/
void kde_KSSL_setProxyUse(kde_KSSL* instPointer,int active, qt_QString * realIP, int realPort, qt_QString * proxy);
void kde_KSSL_setPeerHost(kde_KSSL* instPointer,qt_QString * realHost);
int kde_KSSL_connect(kde_KSSL* instPointer,int sock);
int kde_KSSL_accept(kde_KSSL* instPointer,int sock);
int kde_KSSL_read(kde_KSSL* instPointer,void* buf, int len);
int kde_KSSL_peek(kde_KSSL* instPointer,void* buf, int len);
int kde_KSSL_write(kde_KSSL* instPointer,void* buf, int len);
int kde_KSSL_pending(kde_KSSL* instPointer);
kde_KSSLConnectionInfo* kde_KSSL_connectionInfo(kde_KSSL* instPointer);
kde_KSSLPeerInfo* kde_KSSL_peerInfo(kde_KSSL* instPointer);
int kde_KSSL_doesSSLWork( );

#ifdef __cplusplus
}
#endif
#endif
