/***************************************************************************
                            KImageIO.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KIMAGEIO_H
#define KIMAGEIO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Interface to the KDE Image IO plugin architecture.

 This library allows KDE applications to read and write images in a
 variety of formats, transparently via the @ref QImage and @ref QPixmap load
 and save methods.

 The image processing backends are written as image handlers compatible
 with the @ref QImageIO handler format. The backends are loaded on demand
 when a particular format is requested.

 Currently supported formats include:

 Simply call the @ref -[KImageIO registerFormats] static method declared
 in kimgageio.h.

 <pre>
	 #-include<qpixmap.h>
 	 #-include<kimgio.h>

	int main( int argc, char **argv )
	{
		....
		-[KImageIO registerFormats];

		...	// start main program
	}
 </pre>

 @author Sirtaj Singh Kang

 @version $Id: KImageIO.h,v 1.3 2002/03/15 02:12:21 rdale Exp $
 
 @short 
 Interface to the KDE Image IO plugin architecture.
*/
@interface  KImageIO : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
  Registers all KImageIO supported formats.
   
*/
+ registerFormats;

/** 
  Checks if a special type is supported for writing.
   
*/
+ (BOOL) canWrite: (NSString *)type;

/** 
  Checks if a special type is supported for reading.
   
*/
+ (BOOL) canRead: (NSString *)type;

/** 
 Returns a list of all KImageIO supported formats. 

*/
+ (NSArray *) types: (int)mode;

/** 
 Returns a list of patterns of all KImageIO supported formats. 

 These patterns can be passed to @ref -[KFileDialog getOpenFileName]
 or @ref -[KFileDialog getSaveFileName], for example.

*/
+ (NSString *) pattern: (int)mode;

/** 
  Returns the suffix of an image type.
   
*/
+ (NSString *) suffix: (NSString *)type;

/** 
  Returns the type of given filename.
   
*/
+ (NSString *) type: (NSString *)filename;

/** 
  Returns a list of MIME types for all KImageIO supported formats. 

*/
+ (NSArray *) mimeTypes: (int)_mode;

/** 
 Test to see whether a MIME type is supported to reading/writing.

*/
+ (BOOL) isSupported: (NSString *)_mimeType _mode: (int)_mode;
+ (BOOL) isSupported: (NSString *)_mimeType ;

/** 
 Returns the MIME type of @p _filename.

*/
+ (NSString *) mimeType: (NSString *)_filename;
+ (int) Reading;
+ (int) Writing;
@end

#endif
