<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann <marco.ladermann@gmx.de>
  ** Date:   Thu Mar 06 16:08:06 CET 2003 @672 /Internet Time/
  ** 
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:func="http://exslt.org/functions"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:kde="http://kde.org/functions"
    xmlns:java="http://kde.org/java"

 >
    <!--
      ** All methods definitions are in this stylesheet
      -->
    <!--
      ** Put the definition of all needed method
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMethods">
        <xsl:param name="data"/>
        <!-- Do we need a uncompress function for Pixmap's ? -->
        <xsl:if test="boolean(//image | //pixmap) and not(/UI/pixmapfunction | /UI/pixmapinproject)">
            <xsl:call-template name="putUncompressPixmaps"/>
        </xsl:if>
        <!-- Do we need "polishing" ? -->
        <xsl:if test="//property[@name = 'database']">
            <xsl:call-template name="putPolish"/>
        </xsl:if>
        <!-- The slot for a language change signal -->
        <xsl:call-template name="putLanguageChangeSlot"/>
    </xsl:template>
    <!--
      ** Put the definition of the main method
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMain">
        <xsl:param name="data"/>
        <xsl:if test="not($abstract and /UI/slots/slot)">

    public static void main(String [] args) {
		<xsl:choose>
		<xsl:when test="$kde">
		KCmdLineArgs.init( args , "<xsl:value-of select="$mainClass"/>", "<xsl:value-of select="$mainClass"/>", "<xsl:value-of select="java:toJavaString(/UI/widget/property[@name='caption']/string)"/>", "version");
        KApplication app = new KApplication();
		</xsl:when>
		<xsl:otherwise>
        QApplication app = new QApplication(args);
		</xsl:otherwise>
		</xsl:choose>
        <xsl:value-of select="$mainClass"/> myWidget = new <xsl:value-of select="$mainClass"/>();
        app.setMainWidget( myWidget );
        myWidget.show();
        app.exec();
    }

    static {
        org.kde.qt.qtjava.initialize();
		<xsl:if test="$kde">
		org.kde.koala.kdejava.initialize();
		</xsl:if>
    }</xsl:if>
    </xsl:template>
    

    <xsl:template name="putUncompressPixmaps">

    /**
     * uncompressPixmap extracts a pixmap from coded data
     * @param size of uncompressed data
     * @param data compressed data
     */
    private QPixmap uncompressPixmap(int size, byte [] data) {
        QPixmap pix = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            InflaterInputStream iis = new InflaterInputStream(bais);
            byte [] xpm = new byte [size];
            iis.read(xpm, 0, size);
            pix = new QPixmap(xpm);
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        return pix;
    }
    </xsl:template>
    
    <xsl:template name="putPolish">

    /**
     * polish does some last initialization just before the widget
     * is displayed. Here we setup:
     *   i) databases
     *   ...
     */
    public void polish() {
        <xsl:for-each select="//property[@name = 'database']">
        <xsl:variable name="dataTable" select="java:getNodeName(..)"/>
        if ( <xsl:value-of select="$dataTable"/> != null ) {
            QSqlCursor cursor = <xsl:value-of select="$dataTable"/>.sqlCursor();
            if ( !cursor ) {
                cursor = new QSqlCursor( "<xsl:value-of select="stringlist/string[2]"/>" <xsl:if test="not(stringlist/string[1] = '(default)')">, true, QSqlDatabase.database("<xsl:value-of select="stringlist/string[1]"/>") </xsl:if> );
                <xsl:value-of select="$dataTable"/>.setSqlCursor( cursor, false, true );
            }
            if ( !cursor.isActive() )
                <xsl:value-of select="$dataTable"/>.refresh( QDataTable.RefreshAll );
        }
        </xsl:for-each>
        super.polish();
    }
    </xsl:template>

    <xsl:template name="putLanguageChangeSlot">

    /**
     * SLOT
     * languageChange sets the strings according to current language
     */
   protected void languageChange() {
        <xsl:for-each select="//*[not(name() = 'item' or name() = 'column')]/property[not(@name = 'accel')]/string">
            <xsl:apply-templates select="." mode="property">
                <xsl:with-param name="name" select="../@name"/>
                <xsl:with-param name="data" select="putText"/>
            </xsl:apply-templates>
        </xsl:for-each>
        <xsl:for-each select="//item[property/string]">
            
            <xsl:value-of select="java:getContainerName(.)"/>
        </xsl:for-each>
   }
   </xsl:template>
    
</xsl:stylesheet>

