import org.kde.qt.*;

public class Tut7 extends QVBox {
	public Tut7() {
		QPushButton quit = new QPushButton("Quit", this, "quit");
		quit.setFont(new QFont("Times", 18, QFont.Bold, false));

		connect(quit, SIGNAL("clicked()"), qApp(), SLOT("quit()"));

		QGrid grid = new QGrid(4, this, null, 0);
		
		LCDRange previous = null;
		for(int r = 0; r < 4; r++) {
			for(int c = 0; c < 4; c++) {
				LCDRange lr = new LCDRange(grid);
				if (previous!=null)
					connect(lr, SIGNAL("valueChanged(int)"),
									previous, SLOT("setValue(int)"));
				previous = lr;
			}
		}
	}
	
	public static void main(String[] args) {
		QApplication a = new QApplication(args);
		Tut7 w = new Tut7();
		
		a.setMainWidget(w);
		w.show();
		a.exec();
		return;
	}
	
	static {
		try {
			Class c = Class.forName("org.kde.qt.qtjava");
		} catch (Exception e) {
			e.printStackTrace();
			System.out.println("Can't load qtjava class");
		}
	}
}
