// Qt-CSharp tutorial 5
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class MyWidget : QVBox {

	public MyWidget (QWidget parent, String name) : base (parent, name)
	// In C++, parent and name have default values of 0 (null pointer)
	{
		QPushButton quit = new QPushButton ("Quit", this, "quit");
		quit.SetFont ( new QFont ("Times", 18, QFont.Weight.Bold) );
		
		QObject.Connect ( quit, SIGNAL ("clicked()"), qApp, SLOT ("Quit()") );
		
		QLCDNumber lcd = new QLCDNumber (2, this, "lcd" );
		
		QSlider slider = new QSlider (Orientation.Horizontal, this, "slider");
		// Note that Orientation is defined in the Qt class
		slider.SetRange (0, 99);
		slider.SetValue (0);

		Connect ( slider, SIGNAL ("valueChanged(int)"), lcd, SLOT ("Display(int)") );
	}
	
	public MyWidget (QWidget parent) : this (parent, "") {}
	public MyWidget () : this (null, "") {}
	// Note that it was necessary to use an empty string ("")
	// in the above. Using null does not work at runtime.
}

public class Example {

	public static int Main (String[] args)
	{
		QApplication a = new QApplication (args);
		
		MyWidget w = new MyWidget ();
		a.SetMainWidget (w);
		w.Show ();
		return a.Exec ();
	}
}
