//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QtSupport;
import org.kde.qt.QIODevice;
import org.kde.qt.QIODeviceInterface;
import org.kde.qt.QIODevice;

/**

 A class for reading and writing compressed data onto a device
 (e.g. file, but other usages are possible, like a buffer or a socket).
 To simply read/write compressed files, see deviceForFile.
		@author David Faure <faure@kde.org>
 
		@short    A class for reading and writing compressed data onto a device  (e.

*/
public class KFilterDev extends QIODevice  {
	protected KFilterDev(Class dummy){super((Class) null);}
	/**	
		 Constructs a KFilterDev for a given filter (e.g. gzip, bzip2 etc.).
			@param filter the KFilterBase to use
			@param autoDeleteFilterBase when true this object will become the
		 owner of <code>filter.</code>
		     		@short    Constructs a KFilterDev for a given filter (e.
	*/
	public KFilterDev(KFilterBase filter, boolean autoDeleteFilterBase) {
		super((Class) null);
		newKFilterDev(filter,autoDeleteFilterBase);
	}
	private native void newKFilterDev(KFilterBase filter, boolean autoDeleteFilterBase);
	public KFilterDev(KFilterBase filter) {
		super((Class) null);
		newKFilterDev(filter);
	}
	private native void newKFilterDev(KFilterBase filter);
	/**	
		 Open for reading or writing.
		 If the KFilterBase's device is not opened, it will be opened.
		     		@short    Open for reading or writing.
	*/
	public native boolean open(int mode);
	/**	
		 Close after reading or writing.
		 If the KFilterBase's device was opened by open(), it will be closed.
		     		@short    Close after reading or writing.
	*/
	public native void close();
	public native void flush();
	/**	
		 For writing gzip compressed files only:
		 set the name of the original file, to be used in the gzip header.
			@param fileName the name of the original file
		     		@short    For writing gzip compressed files only:  set the name of the original file, to be used in the gzip header.
	*/
	public native void setOrigFileName(String fileName);
	/**	
		 Call this let this device skip the gzip headers when reading/writing.
		 This way KFilterDev (with gzip filter) can be used as a direct wrapper
		 around zlib - this is used by KZip.
				@short    Call this let this device skip the gzip headers when reading/writing.
	*/
	public native void setSkipHeaders();
	public native long size();
	public native long at();
	/**	
		 That one can be quite slow, when going back. Use with care.
		     		@short    That one can be quite slow, when going back.
	*/
	public native boolean at(long arg1);
	public native boolean atEnd();
	public native long readBlock(StringBuffer data, long maxlen);
	public native long writeBlock(String data, long len);
	public native int getch();
	public native int putch(int arg1);
	public native int ungetch(int arg1);
	/**	
		 Creates an i/o device that is able to read from <code>fileName</code>,
		 whether it's compressed or not. Available compression filters
		 (gzip/bzip2 etc.) will automatically be used.
			 The compression filter to be used is determined from the <code>fileName</code>
		 if <code>mimetype</code> is empty. Pass "application/x-gzip" or "application/x-bzip2"
		 to force the corresponding decompression filter, if available.
			 Warning: application/x-bzip2 may not be available.
		 In that case a QFile opened on the compressed data will be returned !
		 Use KFilterBase.findFilterByMimeType and code similar to what
		 deviceForFile is doing, to better control what's happening.
			 The returned QIODevice has to be deleted after using.
			@param fileName the name of the file to filter
			@param mimetype the mime type of the file to filter, or null if unknown
			@param forceFilter if true, the function will either find a compression filter, or return 0.
		                    If false, it will always return a QIODevice. If no
		                    filter is available it will return a simple QFile.
		                    This can be useful if the file is usable without a filter.
				@return if a filter has been found, the QIODevice for the filter. If the
         filter does not exist, the return value depends on <code>forceFilter.</code>
         The returned QIODevice has to be deleted after using.
     
		@short    Creates an i/o device that is able to read from <code>fileName</code>,  whether it's compressed or not.
	*/
	public static native QIODeviceInterface deviceForFile(String fileName, String mimetype, boolean forceFilter);
	public static native QIODeviceInterface deviceForFile(String fileName, String mimetype);
	public static native QIODeviceInterface deviceForFile(String fileName);
	/**	
		 Creates an i/o device that is able to read from the QIODevice <code>inDevice</code>,
		 whether the data is compressed or not. Available compression filters
		 (gzip/bzip2 etc.) will automatically be used.
			 The compression filter to be used is determined <code>mimetype</code> .
		 Pass "application/x-gzip" or "application/x-bzip2"
		 to use the corresponding decompression filter.
			 Warning: application/x-bzip2 may not be available.
		 In that case 0 will be returned !
			 The returned QIODevice has to be deleted after using.
			@param inDevice input device, becomes owned by this device! Automatically deleted!
			@param mimetype the mime type for the filter
				@return a QIODevice that filters the original stream. Must be deleted after
         using
     
		@short    Creates an i/o device that is able to read from the QIODevice <code>inDevice</code>,  whether the data is compressed or not.
	*/
	public static native QIODeviceInterface device(QIODeviceInterface inDevice, String mimetype);
	/**	
		 Creates an i/o device that is able to read from the QIODevice <code>inDevice</code>,
		 whether the data is compressed or not. Available compression filters
		 (gzip/bzip2 etc.) will automatically be used.
			 The compression filter to be used is determined <code>mimetype</code> .
		 Pass "application/x-gzip" or "application/x-bzip2"
		 to use the corresponding decompression filter.
			 Warning: application/x-bzip2 may not be available.
		 In that case 0 will be returned !
			 The returned QIODevice has to be deleted after using.
			@param inDevice input device. Won't be deleted if <code>autoDeleteInDevice</code> = false
			@param mimetype the mime type for the filter
			@param autoDeleteInDevice if true, <code>inDevice</code> will be deleted automatically
				@return a QIODevice that filters the original stream. Must be deleted after
         using

		@short    Creates an i/o device that is able to read from the QIODevice <code>inDevice</code>,  whether the data is compressed or not.
	*/
	public static native QIODeviceInterface device(QIODeviceInterface inDevice, String mimetype, boolean autoDeleteInDevice);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
