import os, time

from qt import QImage, QLabel, QPixmap, QPushButton, SIGNAL, QColor, QValidator

from kdeui import KMessageBox, KDateValidator, KFloatValidator, KIntValidator, KLineEdit, KLed



class Page3:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 15

        green  = QColor (0, 255, 0)
        yellow = QColor (255, 255, 0)
        red    = QColor (255, 0, 0)

        ivLbl  = QLabel ("KIntValidator", self.page)
        ivLbl.setGeometry (x, y, 100, 20)
        ivLbl.show ()

        self.iv = KLineEdit (self.page)
        self.iv.setGeometry (x, y + 20, 100, 20)
        self.iv.show ()
        self.page.connect (self.iv, SIGNAL("textChanged (const QString &)"), self.ivChanged)

        self.ivVal = KIntValidator (self.page)
        self.ivVal.setRange (20, 50)

        ivRngLbl = QLabel ("Range is 20 - 50", self.page)
        ivRngLbl.setGeometry (x, y + 45, 100, 20)
        ivRngLbl.show ()

        ivAccLbl   = QLabel ("Acceptable", self.page)
        ivAccLbl.setGeometry (x + 125, y + 45, 85, 20)
        ivAccLbl.show ()
        ivInterLbl = QLabel ("Intermediate", self.page)
        ivInterLbl.setGeometry (x + 125, y + 20, 85, 20)
        ivInterLbl.show ()
        ivInvalLbl = QLabel ("Invalid", self.page)
        ivInvalLbl.setGeometry (x + 125, y - 5, 85, 20)
        ivInvalLbl.show ()
        self.ivInvalLed = KLed (red, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.ivInvalLed.setGeometry (x + 215, y - 5, 18, 18)
        self.ivInvalLed.show ()
        self.ivInterLed = KLed (yellow, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.ivInterLed.setGeometry (x + 215, y + 20, 18, 18)
        self.ivInterLed.show ()
        self.ivAccLed = KLed (green, KLed.On, KLed.Sunken, KLed.Circular,self.page)
        self.ivAccLed.setGeometry (x + 215, y + 45, 18, 18)
        self.ivAccLed.show ()

        y = y + 100

        fvLbl  = QLabel ("KFloatValidator", self.page)
        fvLbl.setGeometry (x, y, 100, 20)
        fvLbl.show ()

        self.fv = KLineEdit (self.page)
        self.fv.setGeometry (x, y + 20, 100, 20)
        self.fv.show ()
        self.page.connect (self.fv, SIGNAL("textChanged (const QString &)"), self.fvChanged)

        self.fvVal = KFloatValidator (self.page)
        self.fvVal.setRange (10.0, 40.0)

        fvRngLbl = QLabel ("Range is 10.0 - 40.0", self.page)
        fvRngLbl.setGeometry (x, y + 45, 100, 20)
        fvRngLbl.show ()

        fvAccLbl   = QLabel ("Acceptable", self.page)
        fvAccLbl.setGeometry (x + 125, y + 45, 85, 20)
        fvAccLbl.show ()
        fvInterLbl = QLabel ("Intermediate", self.page)
        fvInterLbl.setGeometry (x + 125, y + 20, 95, 20)
        fvInterLbl.show ()
        fvInvalLbl = QLabel ("Invalid", self.page)
        fvInvalLbl.setGeometry (x + 125, y - 5, 85, 20)
        fvInvalLbl.show ()
        self.fvInvalLed = KLed (red, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.fvInvalLed.setGeometry (x + 215, y - 5, 18, 18)
        self.fvInvalLed.show ()
        self.fvInterLed = KLed (yellow, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.fvInterLed.setGeometry (x + 215, y + 20, 18, 18)
        self.fvInterLed.show ()
        self.fvAccLed = KLed (green, KLed.On, KLed.Sunken, KLed.Circular,self.page)
        self.fvAccLed.setGeometry (x + 215, y + 45, 18, 18)
        self.fvAccLed.show ()

        y = y + 100

        dvLbl  = QLabel ("KDateValidator", self.page)
        dvLbl.setGeometry (x, y, 100, 20)
        dvLbl.show ()

        self.dv = KLineEdit (self.page)
        self.dv.setGeometry (x, y + 20, 100, 20)
        self.dv.show ()
#        self.page.connect (self.dv, SIGNAL("textChanged (const QString &)"), self.dvChanged)

        self.dvVal = KDateValidator (self.page)
#        self.dvVal.setRange (10.0, 40.0)

#        dvRngLbl = QLabel ("Range is 10.0 - 40.0", self.page)
#        dvRngLbl.setGeometry (x, y + 45, 100, 20)
#        dvRngLbl.show ()

        dvBtn = QPushButton ("Validate", self.page)
        dvBtn.setGeometry (x, y + 45, 60, 22)
        dvBtn.show ()
        self.page.connect (dvBtn, SIGNAL ("clicked ()"), self.dvChanged)

        dvNoteLbl = QLabel ("Format is locale dependent\nShort date only\nTry DD-MM-YY", self.page)
        dvNoteLbl.setGeometry (x, y + 70, 150, 60)
        dvNoteLbl.show ()

        dvAccLbl   = QLabel ("Acceptable", self.page)
        dvAccLbl.setGeometry (x + 125, y + 45, 85, 20)
        dvAccLbl.show ()
        dvInterLbl = QLabel ("Intermediate", self.page)
        dvInterLbl.setGeometry (x + 125, y + 20, 85, 20)
        dvInterLbl.show ()
        dvInvalLbl = QLabel ("Invalid", self.page)
        dvInvalLbl.setGeometry (x + 125, y - 5, 85, 20)
        dvInvalLbl.show ()
        self.dvInvalLed = KLed (red, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.dvInvalLed.setGeometry (x + 215, y - 5, 18, 18)
        self.dvInvalLed.show ()
        self.dvInterLed = KLed (yellow, KLed.Off, KLed.Sunken, KLed.Circular,self.page)
        self.dvInterLed.setGeometry (x + 215, y + 20, 18, 18)
        self.dvInterLed.show ()
        self.dvAccLed = KLed (green, KLed.On, KLed.Sunken, KLed.Circular,self.page)
        self.dvAccLed.setGeometry (x + 215, y + 45, 18, 18)
        self.dvAccLed.show ()

    def ivChanged (self):
        self.ivInvalLed.off ()
        self.ivInterLed.off ()
        self.ivAccLed.off ()

        state, i = self.ivVal.validate (self.iv.text ())

        if state == QValidator.Acceptable:
            self.ivAccLed.on ()
        elif state == QValidator.Intermediate:
            self.ivInterLed.on ()
        else:
            self.ivInvalLed.on ()

    def fvChanged (self):
        self.fvInvalLed.off ()
        self.fvInterLed.off ()
        self.fvAccLed.off ()

        state, i = self.fvVal.validate (self.fv.text ())

        if state == QValidator.Acceptable:
            self.fvAccLed.on ()
        elif state == QValidator.Intermediate:
            self.fvInterLed.on ()
        else:
            self.fvInvalLed.on ()

    def dvChanged (self):
        self.dvInvalLed.off ()
        self.dvInterLed.off ()
        self.dvAccLed.off ()

        state, i = self.dvVal.validate (self.dv.text ())

        if state == QValidator.Acceptable:
            self.dvAccLed.on ()
        elif state == QValidator.Intermediate:
            self.dvInterLed.on ()
        else:
            self.dvInvalLed.on ()

class PageNotImpl:
    def __init__ (self, parent):
        self.page = parent.addPage ()

        x = 10
        y = 10

        niLbl   = QLabel ("Nothing is currently implemented for this widget", self.page)
        niLbl.setGeometry (x, y, 300, 20)
        niLbl.show ()

def miscKAlphaPainter (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKCModule (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKColor (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKColorDrag (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKCommand (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKCommandHistory (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKDockWindow (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKFloatValidator (parent):
    parent.currentPageObj = Page3 (parent)

def miscKDateValidator (parent):
    parent.currentPageObj = Page3 (parent)

def miscKIntValidator (parent):
    parent.currentPageObj = Page3 (parent)

def miscKPixmapIO (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKSharedPixmap (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscKSystemTray (parent):
    KMessageBox.information (parent, "See the systray.py example in the templates/ subdirectories")

def miscKThemeBase (parent):
    parent.currentPageObj = PageNotImpl (parent)

def miscQXEmbed (parent):
    parent.currentPageObj = PageNotImpl (parent)

if __name__ == "__main__":
    print
    print "Please run uisampler.py"
    print