#!/usr/bin/env python

#****************************************************************************
#** $Id: menu.py,v 1.1 2004/06/19 20:33:27 sedwards Exp $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys, string
from qt import *

TRUE  = 1
FALSE = 0

# XPM
p1_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFF0000",
"                ",
"                ",
"         ....   ",
"        .XXXX.  ",
" .............. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .............. ",
"                "
]

# XPM
p2_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"   ......       ",
"   .XXX.X.      ",
"   .XXX.XX.     ",
"   .XXX.XXX.    ",
"   .XXX.....    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .........    ",
"                ",
"                "
]

# XPM
p3_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"                ",
"   .........    ",
"  ...........   ",
"  ........ ..   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"   .........    ",
"                ",
"                "
]

p4_xpm = [
' 16 14 5 1',
'. c #000000',
'# c #848284',
'a c #c6c3c6',
'b c #ffff00',
'c c #ffffff',
'aaaaa.........aa',
'aaaa.cccccccc.aa',
'aaaa.c.....c.aaa',
'aaa.cccccccc.aaa',
'aaa.c.....c....a',
'aa.cccccccc.a.a.',
'a..........a.a..',
'.aaaaaaaaaa.a.a.',
'.............aa.',
'.aaaaaa###aa.a.a',
'.aaaaaabbbaa...a',
'.............a.a',
'a.aaaaaaaaa.a.aa',
'aa...........aaa'
]

#  Auxiliary class to provide fancy menu items with different fonts.
#  Used for the "bold" and "underline" menu items in the options menu.

#class MyMenuItem( QCustomMenuItem ):
#  def __init__( self, s=None, f=None ):
#      apply( QCustomMenuItem.__init__,( self, s, f ) )
#      string = QString( s )
#      font   = QFont( f )

#  def paint( self, p, TRUE, FALSE, x, y, w, h ) :
#    p.setFont ( font )
#    p.drawText( x, y, w, h, Qt.AlignLeft | Qt.AlignVCenter | Qt.ShowPrefix | Qt.DontClip, string )
#  def sizeHint( self ):
#    return QFontMetrics( font ).size( Qt.AlignLeft | Qt.AlignVCenter | Qt.ShowPrefix | Qt.DontClip,  string )
    

#
### Implementation of MenuExample class
#

class MenuExample( QWidget ):
  def __init__( self, parent=None, name=None ):
      apply( QWidget.__init__,(self, parent, name) )
      self.p1 = QIconSet( QPixmap ( p1_xpm ) )
      self.p2 = QIconSet( QPixmap ( p2_xpm ) )
      self.p3 = QIconSet( QPixmap ( p3_xpm ) )
      self.p4 = QIconSet( QPixmap ( p4_xpm ) )
      #openIcon  = QPixmap()
      #saveIcon  = QPixmap()
      #printIcon = QPixmap()

      self.printer = QPopupMenu( self )
      #CHECK_PTR( self.printer )
      self.printer.insertTearOffHandle()
      self.printer.insertItem( "&Print to printer", self.printDoc )
      self.printer.insertItem( "Print to &file", self.file )
      self.printer.insertItem( "Print to fa&x", self.fax )
      self.printer.insertSeparator()
      self.printer.insertItem( "Printer &Setup", self.printerSetup )

      self.file = QPopupMenu( self )
      #CHECK_PTR( self.file );
      self.file.insertItem( self.p1, "&Open", self.open, Qt.CTRL+Qt.Key_O )
      self.file.insertItem( self.p2, "&New",  self.news, Qt.CTRL+Qt.Key_N )
      self.file.insertItem( self.p3, "&Save", self.save, Qt.CTRL+Qt.Key_S )
      self.file.insertItem( "&Close", self.closeDoc, Qt.CTRL+Qt.Key_W )
      self.file.insertSeparator()
      self.file.insertItem( self.p4, "&Print", self.printer, Qt.CTRL+Qt.Key_P )
      self.file.insertSeparator()
      self.file.insertItem( "E&xit",  qApp, SLOT( "quit()" ), Qt.CTRL+Qt.Key_Q )
    
      self.edit = QPopupMenu( self )
      #CHECK_PTR( self.edit )
      undoID = self.edit.insertItem( "&Undo", self.undo )
      redoID = self.edit.insertItem( "&Redo", self.redo )
      self.edit.setItemEnabled( undoID, TRUE )
      self.edit.setItemEnabled( redoID, FALSE )

      self.options = QPopupMenu( self )
      #CHECK_PTR( self.options )
      self.options.insertTearOffHandle()
      self.options.setCaption( 'Options' )
      self.options.insertItem( "&Normal Font", self.normal )
      self.options.insertSeparator()

      self.options.polish()  # adjust system settings 
      self.f = QFont( self.options.font() )
      self.f.setBold( TRUE )
      self.boldID = self.options.insertItem( "&Bold" )
      self.options.setAccel( Qt.CTRL+Qt.Key_B, self.boldID )
      self.options.connectItem( self.boldID, self.bold )

      self.f = QFont( self.options.font() )
      self.f.setUnderline( TRUE )
      self.underlineID = self.options.insertItem( "&Underline" )
      self.options.setAccel( Qt.CTRL+Qt.Key_U, self.underlineID )
      self.options.connectItem( self.underlineID, self.underline )
    
      self.isBold = FALSE
      self.isUnderline = FALSE
      self.options.setCheckable( TRUE )
    
      self.options = QPopupMenu()
      #CHECK_PTR( self.options )
      self.options.insertItem( "&Normal Font", self.normal )
      self.options.insertSeparator()
      self.boldID = self.options.insertItem( "&Bold", self.bold )
      self.underlineID = self.options.insertItem( "&Underline", self.underline )

      self.isBold = FALSE
      self.isUnderline = FALSE
      self.options.setCheckable( TRUE )

      self.help = QPopupMenu( self )
      #CHECK_PTR( self.help )
      self.help.insertItem( "&About", self.about, Qt.CTRL+Qt.Key_H )
      self.help.insertItem( "About &Qt", self.aboutQt )

      self.menu = QMenuBar( self )
      #CHECK_PTR( self.menu );
      self.menu.insertItem( "&File", self.file )
      self.menu.insertItem( "&Edit", self.edit )
      self.menu.insertItem( "&Options", self.options )
      self.menu.insertSeparator()
      self.menu.insertItem( "&Help", self.help )
      self.menu.setSeparator( QMenuBar.InWindowsStyle )

      self.label = QLabel( self )
      #CHECK_PTR( self.label )
      self.label.setGeometry( 20, self.rect().center().y()-20, self.width()-40, 40 )
      self.label.setFrameStyle( QFrame.Box | QFrame.Raised )
      self.label.setLineWidth( 1 )
      self.label.setAlignment( Qt.AlignCenter )
      
      self.label.setFont( QFont( "times", 12, QFont.Bold ) )
      self.connect( self, PYSIGNAL( "explain" ), self.label.setText )
      #self.connect( self,  PYSIGNAL( "explain(const char *)" ),
      #              self.label, SLOT( "setText(const char *)" ) )

      self.setMinimumSize( 100, 80 )

  def open( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Open selected", ) )

  def news( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/New selected", ) )

  def save( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Save selected", ) )
        
  def closeDoc( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Close selected", ) )

  def undo( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "Edit/Undo selected", ) )

  def redo( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "Edit/Redo selected", ) )

  def normal( self ):
    self.isBold = FALSE
    self.isUnderline = FALSE
    self.options.setItemChecked( self.boldID, self.isBold )
    self.options.setItemChecked( self.underlineID, self.isUnderline )
    self.emit(PYSIGNAL("explain"), ("Options/Normal selected",))

  def bold( self ):
    self.isBold = not self.isBold
    self.options.setItemChecked( self.boldID, self.isBold )
    self.emit ( PYSIGNAL( "explain" ), ( "Options/Bold selected", ) )

  def underline( self ):
    self.isUnderline = not self.isUnderline
    self.options.setItemChecked( self.underlineID, self.isUnderline )
    self.emit(PYSIGNAL("explain"), ("Options/Underline selected",))

  def about( self ):
    QMessageBox.about( self, "Qt Menu Example",
                       "This example demonstrates simple use of Qt menus.\n"
                       "You can cut and paste lines from it to your own\n"
                       "programs." )

  def aboutQt( self ):
    QMessageBox.aboutQt( self, "Qt Menu Example" )

  def printDoc( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Print selected", ) )

  def file( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Print To File selected", ) )

  def fax( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Print To Fax selected", ) )

  def printerSetup( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Printer Setup selected", ) )

  def resizeEvent( self, ev ):
    self.label.setGeometry( 20, self.rect().center().y()-20, self.width()-40, 40 )

a = QApplication( sys.argv )
m = MenuExample()

a.setMainWidget( m )
m.setCaption( 'MenuExample' )
m.show()
#a.connect( a, SIGNAL('lastWindowClosed()'), a, SLOT('quit()') )
a.exec_loop()
