<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann <marco.ladermann@gmx.de>
  ** Date:   Thu Mar 06 16:08:06 CET 2003 @672 /Internet Time/
  ** 
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:func="http://exslt.org/functions"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:kde="http://kde.org/functions"
    xmlns:java="http://kde.org/java"
 >
    <!--
      ** All methods definitions are in this stylesheet
      -->
    <!--
      ** Put the definition of all needed method
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMethods">
        <xsl:param name="data"/>
        <!-- Do we need a uncompress function for Pixmap's ? -->
        <xsl:if test="boolean(//image | //pixmap) and not(/UI/pixmapfunction | /UI/pixmapinproject)">
            <xsl:call-template name="putDecodePixmaps"/>
        </xsl:if>
        <!-- Do we need "polishing" ? -->
        <xsl:if test="//property[@name = 'database']">
            <xsl:call-template name="putPolish"/>
        </xsl:if>
        <!-- The slot for a language change signal -->
        <xsl:call-template name="putLanguageChangeSlot"/>
    </xsl:template>
    <!--
      ** Put the definition of the main method
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putMain">
        <xsl:param name="data"/>
        <xsl:if test="not($abstract) and $main">

    public static void main(String [] args) {
		<xsl:choose>
		<xsl:when test="$kde">
		KCmdLineArgs.init( args , "<xsl:value-of select="$mainClass"/>", "<xsl:value-of select="$mainClass"/>", "<xsl:value-of select="java:toJavaString(/UI/widget/property[@name='caption']/string)"/>", "version");
        KApplication app = new KApplication();
		</xsl:when>
		<xsl:otherwise>
        QApplication app = new QApplication(args);
        </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="$mainClass"/> myWidget = new <xsl:value-of select="$mainClass"/>();
        app.setMainWidget( myWidget );
        myWidget.show();
        app.exec();
    }</xsl:if>
    </xsl:template>
    

    <xsl:template name="putDecodePixmaps">

    /**
     * decodePixmap extracts a pixmap from coded data
     * @param size of uncompressed data
     * @param code string coded data
     * @param isCompressed need data to be uncompressed
     */
    private static QPixmap decodePixmap(int size, String code, boolean isCompressed) {
        int len = code.length() >> 1;
        byte [] data = new byte[len];
        try {
            for (int i=0, j=0 ; i &lt; len; ++i, j+=2) {
                data[i] = (byte)Short.parseShort(code.substring(j, j+2), 16);
            }
            if (isCompressed) {
                byte [] pic = new byte [size];
                Inflater inflater = new Inflater();
                pic = new byte [size];
                inflater.setInput(data);
                inflater.inflate(pic, 0, size);
                return new QPixmap(pic);
            } else {
                return new QPixmap(data);
            }
        }
        catch (Exception e) {
            System.err.println("Problem, while reading image data: "+e.getMessage());
        }
        return null;
    }
    </xsl:template>
    
    <xsl:template name="putPolish">

    /**
     * polish does some last initialization just before the widget
     * is displayed. Here we setup:
     *   i) databases
     *   ...
     */
    public void polish() {
        <xsl:for-each select="//widget[@class = 'QDataTable' or @class = 'QDataBrowser']">
            <xsl:if test="not( property[@name = 'frameworkCode']/bool = 'false' )">
                <xsl:variable name="dataName" select="java:getNodeName(.)"/>
                <xsl:variable name="conn" select="property[@name='database']/stringlist/string[1]"/>
                <xsl:variable name="table" select="property[@name='database']/stringlist/string[2]"/>
                <xsl:choose>
                    <xsl:when test="@class = 'QDataTable'">
        if ( <xsl:value-of select="$dataName"/> != null ) {
            QSqlCursor cursor = <xsl:value-of select="$dataName"/>.sqlCursor();
            if ( cursor == null ) {<xsl:choose>
                        <xsl:when test="$conn = '(default)'">
                cursor = new QSqlCursor( "<xsl:value-of select="$table"/>" );</xsl:when>
                        <xsl:otherwise>
                cursor = new QSqlCursor( "<xsl:value-of select="$table"/>", true, QSqlDatabase.database("<xsl:value-of select="$conn"/>") );</xsl:otherwise>
                        </xsl:choose>
                if ( <xsl:value-of select="$dataName"/>.isReadOnly() )
                    cursor.setMode( QSqlCursor.ReadOnly );
                <xsl:value-of select="$dataName"/>.setSqlCursor( cursor, false, true );
            }
            if ( !cursor.isActive() )
                <xsl:value-of select="$dataName"/>.refresh( QDataTable.RefreshAll );
        }
                    </xsl:when>
                    <xsl:otherwise>
        if ( <xsl:value-of select="$dataName"/> != null ) {
            if ( <xsl:value-of select="$dataName"/>.sqlCursor() == null ) {<xsl:choose>
                        <xsl:when test="$conn = '(default)'">
                QSqlCursor cursor = new QSqlCursor( "<xsl:value-of select="$table"/>" );</xsl:when>
                        <xsl:otherwise>
                QSqlCursor cursor = new QSqlCursor( "<xsl:value-of select="$table"/>", true, QSqlDatabase.database("<xsl:value-of select="$conn"/>") );</xsl:otherwise>
                        </xsl:choose><xsl:text>
                    </xsl:text>
                    <xsl:value-of select="$dataName"/>.setSqlCursor( cursor, true );
                    <xsl:value-of select="$dataName"/>.refresh();
                    <xsl:value-of select="$dataName"/>.first();
            }
        }
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:for-each>
        super.polish();
    }
    </xsl:template>

    <xsl:template name="putLanguageChangeSlot">

    /**
     * SLOT
     * languageChange sets the strings according to current language
     */
   protected void languageChange() {
        <!-- all "normal" i18n strings -->
        <xsl:for-each select="//*[not(name() = 'item' or name() = 'column' or name() = 'row')]/property/string">
            <xsl:apply-templates select="." mode="property">
                <xsl:with-param name="name" select="../@name"/>
                <xsl:with-param name="data" select="'languageChange'"/>
            </xsl:apply-templates>
        </xsl:for-each>
        <!-- all ListViews -->
        <xsl:for-each select="//widget[item]">
            <xsl:variable name="contName" select="java:getContainerName(.)"/>
            <xsl:for-each select="./column">
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="$contName"/>
                <xsl:text>.header().setLabel( </xsl:text>
                <xsl:value-of select="position() - 1"/>
                <xsl:text>, </xsl:text>
                <xsl:value-of select="java:tr(kde:isUtf8(property[@name = 'text']/string))"/>
                <xsl:text>( &quot;</xsl:text>
                <xsl:value-of select="java:toJavaString(property[@name = 'text']/string)"/>
                <xsl:text>&quot; ) );</xsl:text>
            </xsl:for-each>
            <xsl:value-of select="$nlIndent8"/>
            <xsl:value-of select="$contName"/>
            <xsl:text>.clear();</xsl:text>
            <xsl:variable name="containerClass">
                <xsl:apply-templates mode="toClass" select="."/>
            </xsl:variable>
            <xsl:for-each select="item">
                <xsl:call-template name="putItemDefinition">
                    <xsl:with-param name="class" select="$containerClass"/>
                    <xsl:with-param name="number" select="position() - 1"/>
                    <!-- xsl:with-param name="data" select=""/ -->
                </xsl:call-template>
            </xsl:for-each>
        </xsl:for-each>
        <!-- all Tables -->
        <xsl:for-each select="//widget[(column or row) and not(item)]">
            <xsl:variable name="table" select="property[@name='name']/cstring"/>
            <xsl:for-each select="column">
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="$table"/>
                <xsl:choose>
                    <xsl:when test="substring(../@class, 2) = 'ListView'">
                        <xsl:text>.header()</xsl:text>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>.horizontalHeader()</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:text>.setLabel( </xsl:text>
                <xsl:value-of select="position() - 1"/>
                <xsl:text>, </xsl:text>
                <xsl:value-of select="java:tr(kde:isUtf8(property[@name='text']/string))"/>
                <xsl:text>( &quot;</xsl:text>
                <xsl:value-of select="java:toJavaString(property[@name='text']/string)"/>
                <xsl:if test="property[@name='image']">
                </xsl:if>
                <xsl:text>&quot; ) );</xsl:text>
            </xsl:for-each>
            <xsl:for-each select="row">
                <xsl:value-of select="$nlIndent8"/>
                <xsl:value-of select="$table"/>
                <xsl:text>.verticalHeader().setLabel( </xsl:text>
                <xsl:value-of select="position() - 1"/>
                <xsl:value-of select="java:tr(kde:isUtf8(property[@name='text']/string))"/>
                <xsl:text>( &quot;</xsl:text>
                <xsl:value-of select="java:toJavaString(property[@name='text']/string)"/>
                <xsl:text>&quot; ) );</xsl:text>
            </xsl:for-each>
        </xsl:for-each>
        <!-- Menubar -->
        <xsl:variable name="menubar" select="/UI/menubar/property[@name='name']/cstring"/>
        <xsl:for-each select="/UI/menubar/item">
            <xsl:variable name="findItem">
                <xsl:value-of select="$menubar"/>
                <xsl:text>.findItem(</xsl:text>
                <xsl:value-of select="position()"/>
                <xsl:text>)</xsl:text>
            </xsl:variable>
            <xsl:value-of select="$nlIndent8"/>
            <xsl:text>if (</xsl:text>
            <xsl:value-of select="$findItem"/>
            <xsl:text> != null)</xsl:text>
            <xsl:value-of select="$nlIndent8"/>
            <xsl:text>    </xsl:text>
            <xsl:value-of select="$findItem"/>
            <xsl:text>.setText( </xsl:text>
            <xsl:value-of select="java:tr(kde:isUtf8(@text))"/>
            <xsl:text>( &quot;</xsl:text>
            <xsl:value-of select="java:toJavaString(@text)"/>
            <xsl:text>&quot; ) );</xsl:text>
        </xsl:for-each>
   }
   </xsl:template>
    
</xsl:stylesheet>

