/***************************************************************************
                          wirelesstools.cpp
                             -------------------
    begin                : Fri Feb 13 2004
    copyright            : (C) 2004 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "config.h"
#include <qfile.h>
#include <qstringlist.h>

#include <kdebug.h>

extern "C" {
#include <iwlib.h>
}

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "stuff.h"
#include "wirelesstools.h"

// domi:the wireless-tools people managed to change their interfaces
// around.  Someone with more knowledge of this code should look into
// moving to use the new iw_range interfaces.
#if HAVE_IW_27
inline int wtc_private_iw_get_stats( int skfd, char* ifname, iwstats* stats )
{
  return iw_get_stats( skfd, ifname, stats, 0, 0 );
}
#else
inline int wtc_private_iw_get_stats( int skfd, char* ifname, iwstats* stats )
{
  return iw_get_stats( skfd, ifname, stats );
}
#endif

/* ================================== FROM IWCONFIG.C ================================== */
int get_info(int skfd, char * ifname, struct wireless_info * info)
{
  struct iwreq		wrq;

  memset((char *) info, 0, sizeof(struct wireless_info));

  /* Get wireless name */
  if(iw_get_ext(skfd, ifname, SIOCGIWNAME, &wrq) < 0)
    {
      /* If no wireless name : no wireless extensions */
      /* But let's check if the interface exists at all */
      struct ifreq ifr;

      strcpy(ifr.ifr_name, ifname);
      if(ioctl(skfd, SIOCGIFFLAGS, &ifr) < 0)
	return(-ENODEV);
      else
	return(-ENOTSUP);
    }
  else
    {
      strncpy(info->name, wrq.u.name, IFNAMSIZ);
      info->name[IFNAMSIZ] = '\0';
    }

  /* Get ranges */
  if(iw_get_range_info(skfd, ifname, &(info->range)) >= 0)
    info->has_range = 1;

  /* Get network ID */
  if(iw_get_ext(skfd, ifname, SIOCGIWNWID, &wrq) >= 0)
    {
      info->has_nwid = 1;
      memcpy(&(info->nwid), &(wrq.u.nwid), sizeof(iwparam));
    }

  /* Get frequency / channel */
  if(iw_get_ext(skfd, ifname, SIOCGIWFREQ, &wrq) >= 0)
    {
      info->has_freq = 1;
      info->freq = iw_freq2float(&(wrq.u.freq));
    }

  /* Get sensitivity */
  if(iw_get_ext(skfd, ifname, SIOCGIWSENS, &wrq) >= 0)
    {
      info->has_sens = 1;
      memcpy(&(info->sens), &(wrq.u.sens), sizeof(iwparam));
    }

  /* Get encryption information */
  wrq.u.data.pointer = (caddr_t) info->key;
  wrq.u.data.length = IW_ENCODING_TOKEN_MAX;
  wrq.u.data.flags = 0;
  if(iw_get_ext(skfd, ifname, SIOCGIWENCODE, &wrq) >= 0)
    {
      info->has_key = 1;
      info->key_size = wrq.u.data.length;
      info->key_flags = wrq.u.data.flags;
    }

  /* Get ESSID */
  wrq.u.essid.pointer = (caddr_t) info->essid;
  wrq.u.essid.length = IW_ESSID_MAX_SIZE + 1;
  wrq.u.essid.flags = 0;
  if(iw_get_ext(skfd, ifname, SIOCGIWESSID, &wrq) >= 0)
    {
      info->has_essid = 1;
      info->essid_on = wrq.u.data.flags;
    }

  /* Get AP address */
  if(iw_get_ext(skfd, ifname, SIOCGIWAP, &wrq) >= 0)
    {
      info->has_ap_addr = 1;
      memcpy(&(info->ap_addr), &(wrq.u.ap_addr), sizeof (sockaddr));
    }

  /* Get NickName */
  wrq.u.essid.pointer = (caddr_t) info->nickname;
  wrq.u.essid.length = IW_ESSID_MAX_SIZE + 1;
  wrq.u.essid.flags = 0;
  if(iw_get_ext(skfd, ifname, SIOCGIWNICKN, &wrq) >= 0)
    if(wrq.u.data.length > 1)
      info->has_nickname = 1;

  /* Get bit rate */
  if(iw_get_ext(skfd, ifname, SIOCGIWRATE, &wrq) >= 0)
    {
      info->has_bitrate = 1;
      memcpy(&(info->bitrate), &(wrq.u.bitrate), sizeof(iwparam));
    }

  /* Get RTS threshold */
  if(iw_get_ext(skfd, ifname, SIOCGIWRTS, &wrq) >= 0)
    {
      info->has_rts = 1;
      memcpy(&(info->rts), &(wrq.u.rts), sizeof(iwparam));
    }

  /* Get fragmentation threshold */
  if(iw_get_ext(skfd, ifname, SIOCGIWFRAG, &wrq) >= 0)
    {
      info->has_frag = 1;
      memcpy(&(info->frag), &(wrq.u.frag), sizeof(iwparam));
    }

  /* Get operation mode */
  if(iw_get_ext(skfd, ifname, SIOCGIWMODE, &wrq) >= 0)
    {
      info->mode = wrq.u.mode;
      if((info->mode < IW_NUM_OPER_MODE) && (info->mode >= 0))
	info->has_mode = 1;
    }

  /* Get Power Management settings */
  wrq.u.power.flags = 0;
  if(iw_get_ext(skfd, ifname, SIOCGIWPOWER, &wrq) >= 0)
    {
      info->has_power = 1;
      memcpy(&(info->power), &(wrq.u.power), sizeof(iwparam));
    }

#if WIRELESS_EXT > 9
  /* Get Transmit Power */
  if(iw_get_ext(skfd, ifname, SIOCGIWTXPOW, &wrq) >= 0)
    {
      info->has_txpower = 1;
      memcpy(&(info->txpower), &(wrq.u.txpower), sizeof(iwparam));
    }
#endif

#if WIRELESS_EXT > 10
  /* Get retry limit/lifetime */
  if(iw_get_ext(skfd, ifname, SIOCGIWRETRY, &wrq) >= 0)
    {
      info->has_retry = 1;
      memcpy(&(info->retry), &(wrq.u.retry), sizeof(iwparam));
    }
#endif	/* WIRELESS_EXT > 10 */

  /* Get stats */
  if(wtc_private_iw_get_stats(skfd, ifname, &(info->stats)) >= 0)
    {
      info->has_stats = 1;
    }

  return(0);
}
/* ================================ END IWCONFIG.C ================================ */

// bool already_warned = false;

QString
return_info (deviceinfo * transfer, bool fetch_ip)
{
  wireless_info *tempic1 = new (wireless_info);
  iwstats *tempic2 = new (iw_statistics);
  if (transfer->used_interface == "")
    {
      if (!already_warned) kdDebug() << "Autodetecting...";
      QFile procnetdev ("/proc/net/dev");
      procnetdev.open (IO_ReadOnly);
      QStringList liste;
      QString temp = "";
      QString temptrash = "X";
      int end = 1;
      while ((end != 0) && (temp != temptrash))
	{
	  end = procnetdev.readLine (temp, 9999);
	  temptrash = temp;
	  temp.truncate (temp.find (":") > 0 ? temp.find (":") : 0);
	  temp = temp.stripWhiteSpace ();
	  if ((end != 0) && (temp != ""))
	    liste += temp;
	}
      for (QStringList::Iterator it = liste.begin (); it != liste.end (); ++it)
	{
	  if (!already_warned) kdDebug() << "[ " << (*it).latin1() << " ] ";
	  char device[128];
	  snprintf (device,128,"%s",(*it).latin1());
    int result = get_info (transfer->skfd, device, tempic1);
	  if ((result != -ENODEV) && (result != -ENOTSUP))
	    {
	      char device[128];
	      snprintf(device,128,"%s",(*it).latin1());
	      wtc_private_iw_get_stats (transfer->skfd, device, tempic2);
	      kdDebug() << "Found!\n";
        already_warned=false;
	      transfer->has_freq = tempic1->has_freq;
	      transfer->freq = tempic1->freq;
	      transfer->mode = tempic1->mode;
	      transfer->has_mode = tempic1->has_mode;
	      transfer->has_key = tempic1->has_key;
	      char *test = (char *) tempic1->key;
	      transfer->key = test;
	      transfer->key_size = tempic1->key_size;
	      transfer->key_flags = tempic1->key_flags;
	      transfer->essid = tempic1->essid;
	      transfer->ap_addr = tempic1->ap_addr;
	      transfer->bitrate = tempic1->bitrate;
	      transfer->used_interface = *it;
	      transfer->qual = tempic2->qual;
	      transfer->has_range = tempic1->has_range;
	      transfer->range = tempic1->range;
	      if (fetch_ip) local_ip (transfer);
	      delete tempic1;
	      delete tempic2;
	      return *it;
	    }
	}
      if (!already_warned) kdDebug() << "\nFound nothing. Scanning will continue every second without further notice.\n";
      already_warned=true;
      transfer->qual.qual = 0;
      transfer->qual.noise = 154;
      transfer->qual.level = 154;
      transfer->has_freq = tempic1->has_freq;
      transfer->freq = tempic1->freq;
      transfer->mode = tempic1->mode;
      transfer->has_mode = tempic1->has_mode;
      transfer->has_key = tempic1->has_key;
      char *test = (char *) tempic1->key;
      transfer->key = test;
      transfer->key_size = tempic1->key_flags;
      transfer->key_flags = tempic1->key_flags;
      transfer->essid = tempic1->essid;
      transfer->ap_addr = tempic1->ap_addr;
      transfer->bitrate = tempic1->bitrate;
      transfer->used_interface = "";
      transfer->qual = tempic2->qual;
      transfer->has_range = tempic1->has_range;
      transfer->range = tempic1->range;
      if (fetch_ip) local_ip (transfer);
      delete tempic1;
      delete tempic2;
      return transfer->used_interface;
    }
  else
    {
    char device[128];
    snprintf(device,128,"%s",transfer->used_interface.latin1 ());
    int result = get_info (transfer->skfd, device, tempic1);
    if ((result != -ENODEV) && (result != -ENOTSUP))
	{
	  char device[128];
	  snprintf(device,128,"%s",transfer->used_interface.latin1());
	  wtc_private_iw_get_stats (transfer->skfd, device, tempic2);
	  transfer->has_freq = tempic1->has_freq;
	  transfer->freq = tempic1->freq;
	  transfer->mode = tempic1->mode;
	  transfer->has_mode = tempic1->has_mode;
	  transfer->has_key = tempic1->has_key;
	  char *test = (char *) tempic1->key;
	  transfer->key = test;
	  transfer->key_size = tempic1->key_flags;
	  transfer->key_flags = tempic1->key_flags;
	  transfer->essid = tempic1->essid;
	  transfer->ap_addr = tempic1->ap_addr;
	  transfer->bitrate = tempic1->bitrate;
	  transfer->qual = tempic2->qual;
	  transfer->has_range = tempic1->has_range;
	  transfer->range = tempic1->range;
	  if (fetch_ip) local_ip (transfer);
	  delete tempic1;
	  delete tempic2;
	  return transfer->used_interface;
	}
      else
	{
	  kdDebug() << "Looks like the card has been detached. Switching back to autodetect mode.\n";
	  transfer->qual.qual = 0;
	  transfer->qual.level = 154;
	  transfer->qual.noise = 154;
	  transfer->has_freq = tempic1->has_freq;
	  transfer->freq = tempic1->freq;
	  transfer->mode = tempic1->mode;
	  transfer->has_mode = tempic1->has_mode;
	  transfer->has_key = tempic1->has_key;
	  char *test = (char *) tempic1->key;
	  transfer->key = test;
	  transfer->key_size = tempic1->key_flags;
	  transfer->key_flags = tempic1->key_flags;
	  transfer->essid = tempic1->essid;
	  transfer->ap_addr = tempic1->ap_addr;
	  transfer->bitrate = tempic1->bitrate;
	  transfer->used_interface = "";
	  transfer->qual = tempic2->qual;
	  transfer->has_range = tempic1->has_range;
	  transfer->range = tempic1->range;
	  if (fetch_ip) local_ip (transfer);
    already_warned=false;
	  delete tempic1;
	  delete tempic2;
	  return "";
	}
    }
}

void local_ip (deviceinfo * device)
{
  struct sockaddr *sa;
  struct sockaddr_in *sin;
  struct ifreq ifr;
  /* Copy the interface name into the buffer */
  strncpy (ifr.ifr_name, device->used_interface.latin1 (), IFNAMSIZ);

  if (ioctl (device->skfd, SIOCGIFADDR, &ifr) == -1)
    {
      device->ip_addr = "unavailable";
      return;
    }
  /* Now the buffer will contain the information we requested */
  sa = (struct sockaddr *) &(ifr.ifr_addr);
  if (sa->sa_family == AF_INET)
    {
      sin = (struct sockaddr_in *) sa;
      device->ip_addr = (QString) inet_ntoa (sin->sin_addr);
      return;
    }
  device->ip_addr = "unavailable";
}
