#
# Find the MLT includes and library
#

FIND_PROGRAM(MLT_CONFIG_EXECUTABLE pkg-config)
EXEC_PROGRAM(${MLT_CONFIG_EXECUTABLE} ARGS --variable=prefix mlt++ OUTPUT_VARIABLE MLT_PATH )
MESSAGE(STATUS "Found MLT INSTALL PATH: ${MLT_PATH}")
ADD_DEFINITIONS(-DMLT_PREFIX=\\\"\"${MLT_PATH}\"\\\")

FIND_PATH(LIBMLT_INCLUDE_DIR 
  NAMES framework/mlt.h
  PATHS ${MLT_PATH}/include/mlt /usr/local/include/mlt /usr/include/mlt
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found MLT INCLUDES: ${LIBMLT_INCLUDE_DIR}")

FIND_LIBRARY(LIBMLT_LIBRARY
  NAMES mlt
  PATHS ${MLT_PATH}/lib /usr/lib /usr/local/lib
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found MLT LIBR: ${LIBMLT_LIBRARY}")

FIND_PATH(LIBMLTPLUS_INCLUDE_DIR 
  NAMES mlt++/Mlt.h
  PATHS ${MLT_PATH}/include /usr/local/include /usr/include
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found MLT++ INCLUDES: ${LIBMLTPLUS_INCLUDE_DIR}")

FIND_LIBRARY(LIBMLTPLUS_LIBRARY
  NAMES mlt++
  PATHS ${MLT_PATH}/lib /usr/lib /usr/local/lib
  NO_DEFAULT_PATH
)

MESSAGE(STATUS "Found MLT++ LIBR: ${LIBMLTPLUS_LIBRARY}")

IF (LIBMLT_LIBRARY AND LIBMLT_INCLUDE_DIR)
  SET( LIBMLT_FOUND 1 )
  SET( LIBMLT_LIBRARIES ${LIBMLT_LIBRARY} )
ELSE (LIBMLT_LIBRARY AND LIBMLT_INCLUDE_DIR)
  SET( LIBMLT_FOUND 0 )
ENDIF (LIBMLT_LIBRARY AND LIBMLT_INCLUDE_DIR)


IF (LIBMLTPLUS_LIBRARY AND LIBMLTPLUS_INCLUDE_DIR)
  SET( LIBMLT_FOUND 1 )
  SET( LIBMLTPLUS_LIBRARIES ${LIBMLTPLUS_LIBRARY} )
ELSE (LIBMLTPLUS_LIBRARY AND LIBMLTPLUS_INCLUDE_DIR)
  SET( LIBMLT_FOUND 0 )
ENDIF (LIBMLTPLUS_LIBRARY AND LIBMLTPLUS_INCLUDE_DIR)

IF (LIBMLT_FOUND)
  IF (NOT LIBMLT_FIND_QUIETLY)
    MESSAGE(STATUS "Found MLT library: ${LIBMLT_LIBRARY}")
  ENDIF (NOT LIBMLT_FIND_QUIETLY)
ELSE (LIBMLT_FOUND)
  IF (LIBMLT_FIND_REQUIRED)
    MESSAGE(FATAL_ERROR "Could not find MLT library")
  ENDIF (LIBMLT_FIND_REQUIRED)
ENDIF (LIBMLT_FOUND)

