/*
   SPDX-FileCopyrightText: 2016-2020 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "automaticaddcontactsconfiguretab.h"
#include "automaticaddcontactstabwidget.h"

#include <QHBoxLayout>
#include <QTabWidget>
#include <KSharedConfig>
#include <QRegularExpression>
#include <KIdentityManagement/IdentityManager>
#include <KIdentityManagement/Identity>

AutomaticAddContactsConfigureTab::AutomaticAddContactsConfigureTab(QWidget *parent)
    : QWidget(parent)
{
    auto *mainLayout = new QHBoxLayout(this);
    mainLayout->setObjectName(QStringLiteral("mainlayout"));
    mainLayout->setContentsMargins({});
    mTabWidget = new QTabWidget(this);
    mTabWidget->setObjectName(QStringLiteral("tabwidget"));
    mainLayout->addWidget(mTabWidget);
    initTab(KIdentityManagement::IdentityManager::self());
}

AutomaticAddContactsConfigureTab::~AutomaticAddContactsConfigureTab()
{
}

void AutomaticAddContactsConfigureTab::initTab(KIdentityManagement::IdentityManager *identityManager)
{
    KIdentityManagement::IdentityManager::ConstIterator end = identityManager->end();
    for (KIdentityManagement::IdentityManager::ConstIterator it = identityManager->begin(); it != end; ++it) {
        auto *w = new AutomaticAddContactsTabWidget(this);
        connect(w, &AutomaticAddContactsTabWidget::configureChanged, this, &AutomaticAddContactsConfigureTab::configureChanged);
        mTabWidget->addTab(w, QStringLiteral("%1 (%2)").arg((*it).identityName(), (*it).primaryEmailAddress()));
        w->setIdentity((*it).uoid());
        mListTabWidget.append(w);
    }
}

void AutomaticAddContactsConfigureTab::loadSettings()
{
    for (AutomaticAddContactsTabWidget *w : qAsConst(mListTabWidget)) {
        w->loadSettings();
    }
}

void AutomaticAddContactsConfigureTab::saveSettings()
{
    KSharedConfig::Ptr config = KSharedConfig::openConfig();
    // first, delete all filter groups:
    const QStringList filterGroups = config->groupList().filter(QRegularExpression(QStringLiteral("Automatic Add Contacts \\d+")));
    for (const QString &group : filterGroups) {
        config->deleteGroup(group);
    }
    for (AutomaticAddContactsTabWidget *w : qAsConst(mListTabWidget)) {
        w->saveSettings();
    }
}

void AutomaticAddContactsConfigureTab::resetSettings()
{
    for (AutomaticAddContactsTabWidget *w : qAsConst(mListTabWidget)) {
        w->resetSettings();
    }
}
