/*
  This file is part of libkldap.
  Copyright (c) 2004-2006 Szombathelyi György <gyurco@freemail.hu>
    
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General  Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
            
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
                    
  You should have received a copy of the GNU Library General Public License
  along with this library; see the file COPYING.LIB.  If not, write to
  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
  Boston, MA 02110-1301, USA.
*/

#include "ldapcontrol.h"

using namespace KLDAP;

class LdapControl::LdapControlPrivate {
  public:
    QString mOid;
    QByteArray mValue;
    bool mCritical;
};

LdapControl::LdapControl()
  : d( new LdapControlPrivate )
{
}

LdapControl::LdapControl( QString &oid, QByteArray &value, bool critical )
  : d( new LdapControlPrivate )
{
  setControl( oid, value, critical );
}

LdapControl::LdapControl( const LdapControl &that )
  : d( new LdapControlPrivate )
{
  setControl( that.d->mOid, that.d->mValue, that.d->mCritical );
}

LdapControl& LdapControl::operator= (const LdapControl& that)
{
  if ( this == &that ) return *this;

  setControl( that.d->mOid, that.d->mValue, that.d->mCritical );

  return *this;
}     

LdapControl::~LdapControl()
{
  delete d;
}

void LdapControl::setControl( const QString &oid, const QByteArray &value, bool critical )
{
  d->mOid = oid; d->mValue = value; d->mCritical = critical;
}

QString LdapControl::oid() const
{
  return d->mOid;
}

QByteArray LdapControl::value() const
{
  return d->mValue;
}

bool LdapControl::critical() const
{
  return d->mCritical;
}

void LdapControl::setOid( const QString &oid )
{
  d->mOid = oid;
}

void LdapControl::setValue( const QByteArray &value )
{
  d->mValue = value;
}

void LdapControl::setCritical( bool critical )
{
  d->mCritical = critical;
}
