#ifndef __bugdetails_h__
#define __bugdetails_h__

#include "person.h"
#include "bugdetailspart.h"
#include "bugdetailsimpl.h"

#include <q3valuelist.h>

#include <ksharedptr.h>

class BugDetailsImpl;

class BugDetails
{
public:
    typedef QList<BugDetails> List;
    struct Attachment {
        QByteArray contents;
        QString filename;
    };

    BugDetails();
    BugDetails( BugDetailsImpl *impl );
    BugDetails( const BugDetails &other );
    BugDetails &operator=( const BugDetails &rhs );
    ~BugDetails();

    QString version() const;
    QString source() const;
    QString compiler() const;
    QString os() const;
    BugDetailsPart::List parts() const;
    void addAttachmentDetails( const QList<BugDetailsImpl::AttachmentDetails>& attch );
    QList<BugDetailsImpl::AttachmentDetails> attachmentDetails() const;
    QList<BugDetails::Attachment> extractAttachments() const;
    static QList<BugDetails::Attachment> extractAttachments( const QString& text );

    QDateTime submissionDate() const;
    int age() const;

    bool operator==( const BugDetails &rhs );

    bool isNull() const { return m_impl; }

private:
    BugDetailsImpl *impl() { return m_impl.data(); }

    KSharedPtr<BugDetailsImpl> m_impl;
};

#endif

/* vim: set sw=4 ts=4 et softtabstop=4: */

