
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Jun 23 2003
 */

#include "javacodecomment.h"
#include <qregexp.h>

// Constructors/Destructors
//

JavaCodeComment::JavaCodeComment ( CodeDocument * doc, const QString & text )
        : CodeComment (doc, text)
{

}

JavaCodeComment::~JavaCodeComment ( ) { }

//
// Methods
//


// Accessor methods
//


// Public attribute accessor methods
//

// Other methods
//

QString JavaCodeComment::getNewEditorLine ( int amount ) {
    QString line = getIndentationString(amount) + "// ";
    return line;
}

/** UnFormat a long text string. Typically, this means removing
 *  the indentaion (linePrefix) and/or newline chars from each line.
 */
QString JavaCodeComment::unformatText ( const QString & text , const QString & indent)
{

    // remove leading or trailing comment stuff
    QString mytext = TextBlock::unformatText(text, indent);

    // now leading slashes
    mytext.remove(QRegExp("^\\/\\/\\s*"));
    return mytext;
}

/**
 * @return      QString
 */
QString JavaCodeComment::toString ( )
{

    QString output = "";

    // simple output method
    if(getWriteOutText())
    {
        QString indent = getIndentationString();
        QString endLine = getNewLineEndingChars();
        output.append(formatMultiLineText (getText(), indent +"// ", endLine));
    }

    return output;
}


#include "javacodecomment.moc"
