/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

/*  This code generated by:
 *      Author : thomas
 *      Date   : Mon Jun 23 2003
 */

#include <kconfig.h>

#include "javacodegenerationpolicy.h"
#include "javacodegenerationpolicypage.h"
#include "javacodegenerator.h"

const JavaCodeGenerationPolicy::AccessorScope JavaCodeGenerationPolicy::DEFAULT_ACCESSOR_SCOPE = FromParent;
const JavaCodeGenerationPolicy::JavaCommentStyle JavaCodeGenerationPolicy::DEFAULT_COMMENT = SlashStar;
const bool JavaCodeGenerationPolicy::DEFAULT_AUTO_GEN_EMPTY_CONSTRUCTORS = false;
const bool JavaCodeGenerationPolicy::DEFAULT_AUTO_GEN_ACCESSORS = true;

// Constructors/Destructors
//

JavaCodeGenerationPolicy::JavaCodeGenerationPolicy ( JavaCodeGenerator * parent, CodeGenerationPolicy *defaults )
    : CodeGenerationPolicy ( (QObject*) parent, defaults )
{
	initFields(parent);
	setDefaults(defaults,false);
}

JavaCodeGenerationPolicy::JavaCodeGenerationPolicy ( JavaCodeGenerator * parent, KConfig *config)
    : CodeGenerationPolicy ( (QObject*) parent, config)
{
	initFields(parent);
	setDefaults(config,false);
}

JavaCodeGenerationPolicy::~JavaCodeGenerationPolicy ( ) { }

//
// Methods
//

// Accessor methods
//

// Public attribute accessor methods
//

/** Get the default scope for new accessor methods.
 */
JavaCodeGenerationPolicy::AccessorScope JavaCodeGenerationPolicy::getAccessorScope () {
	return m_defaultAccessorScope;
}

/** Set the default scope for new accessor methods.
 */
void JavaCodeGenerationPolicy::setAccessorScope (AccessorScope scope) {
	m_defaultAccessorScope = scope;
	emit modifiedCodeContent();
}

/**
 * Set the value of m_commentStyle
 * @param new_var the new value of m_commentStyle
 */
void JavaCodeGenerationPolicy::setCommentStyle ( JavaCommentStyle new_var ) {
	m_commentStyle = new_var;
	emit modifiedCodeContent();
}

/**
 * Get the value of m_commentStyle
 * @return the value of m_commentStyle
 */
JavaCodeGenerationPolicy::JavaCommentStyle JavaCodeGenerationPolicy::getCommentStyle ( ) {
	return m_commentStyle;
}

/**
 * Set the value of m_autoGenerateConstructors
 * @param new_var the new value
 */
void JavaCodeGenerationPolicy::setAutoGenerateConstructors( bool var ) {
        m_autoGenerateConstructors = var;
	emit modifiedCodeContent();
}

/**
 * Get the value of m_autoGenerateConstructors
 * @return the value of m_autoGenerateConstructors
 */
bool JavaCodeGenerationPolicy::getAutoGenerateConstructors( ){
        return m_autoGenerateConstructors;
}

/**
 * Set the value of m_autoGenerateAccessors
 * @param new_var the new value
 */
void JavaCodeGenerationPolicy::setAutoGenerateAccessors( bool var ) {
        m_autoGenerateAccessors = var;
	emit modifiedCodeContent();
}

/**
 * Get the value of m_autoGenerateConstructors
 * @return the value of m_autoGenerateConstructors
 */
bool JavaCodeGenerationPolicy::getAutoGenerateAccessors( ){
        return m_autoGenerateAccessors;
}

// a little utility method so we can have our codegenerationpolicy page know what
// the status of the ant document build is
bool JavaCodeGenerationPolicy::getBuildANTCodeDocument()
{
        return m_parentCodeGenerator->getCreateANTBuildFile();
}

// a little utility method so we can have our codegenerationpolicy page can change
// the status of the ANT document build is
void JavaCodeGenerationPolicy::setBuildANTCodeDocument( bool buildIt )
{
        m_parentCodeGenerator->setCreateANTBuildFile(buildIt);
	emit modifiedCodeContent();
}

// Other methods
//

void JavaCodeGenerationPolicy::writeConfig ( KConfig * config )
{

	// write ONLY the Java specific stuff
	config->setGroup("Java Code Generation");

	config->writeEntry("defaultAccessorScope",getAccessorScope());
	config->writeEntry("commentStyle",getCommentStyle());
	config->writeEntry("autoGenEmptyConstructors",getAutoGenerateConstructors());
	config->writeEntry("autoGenAccessors",getAutoGenerateAccessors());
	config->writeEntry("buildANTDocument",getBuildANTCodeDocument());

}

void JavaCodeGenerationPolicy::setDefaults ( CodeGenerationPolicy * clone, bool emitUpdateSignal )
{

	JavaCodeGenerationPolicy * jclone;
	if (!clone)
		return;

	// do the super class
	CodeGenerationPolicy::setDefaults(clone, false);

	// NOW block signals for java param setting
        blockSignals(true); // we need to do this because otherwise most of these
                           // settors below will each send the modifiedCodeContent() signal
                           // needlessly (we can just make one call at the end).


	// now do java-specific stuff IF our clone is also a JavaCodeGenerationPolicy object
 	if((jclone = dynamic_cast<JavaCodeGenerationPolicy*>(clone)))
	{
		setAccessorScope(jclone->getAccessorScope());
		setCommentStyle(jclone->getCommentStyle());
		setAutoGenerateConstructors(jclone->getAutoGenerateConstructors());
		setAutoGenerateAccessors(jclone->getAutoGenerateAccessors());
		setBuildANTCodeDocument(jclone->getBuildANTCodeDocument());
	}

        blockSignals(false); // "as you were citizen"

	if(emitUpdateSignal)
		emit modifiedCodeContent();

}

void JavaCodeGenerationPolicy::setDefaults( KConfig * config, bool emitUpdateSignal )
{

	if(!config)
		return;

        // call the superclass to init default stuff
        CodeGenerationPolicy::setDefaults(config, false);

	// NOW block signals (because call to super-class method will leave value at "true")
        blockSignals(true); // we need to do this because otherwise most of these
                            // settors below will each send the modifiedCodeContent() signal
                            // needlessly (we can just make one call at the end).

	// now do java specific stuff
        config -> setGroup("Java Code Generation");

	setAccessorScope((AccessorScope)config->readNumEntry("defaultAccessorScope",DEFAULT_ACCESSOR_SCOPE));
	setCommentStyle((JavaCommentStyle)config->readNumEntry("commentStyle",DEFAULT_COMMENT));
	setAutoGenerateConstructors(config->readBoolEntry("autoGenEmptyConstructors",DEFAULT_AUTO_GEN_EMPTY_CONSTRUCTORS));
	setAutoGenerateAccessors(config->readBoolEntry("autoGenAccessors",DEFAULT_AUTO_GEN_ACCESSORS));
	setBuildANTCodeDocument(config->readBoolEntry("buildANTDocument",JavaCodeGenerator::DEFAULT_BUILD_ANT_DOC));

        blockSignals(false); // "as you were citizen"

	if(emitUpdateSignal)
		emit modifiedCodeContent();
}


/**
 * Create a new dialog interface for this object.
 * @return dialog object
 */
CodeGenerationPolicyPage * JavaCodeGenerationPolicy::createPage ( QWidget *parent, const char *name ) {
        return new JavaCodeGenerationPolicyPage ( parent, name, this );
}

void JavaCodeGenerationPolicy::initFields ( JavaCodeGenerator * parent ) {

        m_parentCodeGenerator = parent;

	m_defaultAccessorScope = DEFAULT_ACCESSOR_SCOPE;
	m_commentStyle = DEFAULT_COMMENT;
	m_autoGenerateConstructors = DEFAULT_AUTO_GEN_EMPTY_CONSTRUCTORS;
        m_autoGenerateAccessors = DEFAULT_AUTO_GEN_ACCESSORS;

}


#include "javacodegenerationpolicy.moc"
