/***************************************************************************
                          reportview.cpp  -  description
                             -------------------
    begin                : Sun Oct 15 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdebug.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <khtml_part.h>
#include <kglobalsettings.h>

#include <qvbox.h>
#include <qpixmap.h>

#include "reportview.h"

reportView::reportView(QString reportLocation)
        : KDialogBase( (QWidget *)0, "report", false, QString::null, Close ) {
    m_locationCode = reportLocation;
    QVBox *vbox = makeVBoxMainWidget();
    m_reportView = new KHTMLPart(vbox, "m_reportView");
    resize(450, 325);
    centerOnScreen( this );

    m_weatherService = new DCOPRef("KWeatherService", "WeatherService");

    QPixmap icon = callDCOP( "icon" );
    setIcon( icon );

    render();
}

reportView::~reportView(){
    delete m_weatherService;
}

DCOPReply reportView::callDCOP( const QString &name )
{
  QCString function = QString( "%1(QString)" ).arg( name ).local8Bit();
  DCOPReply reply = m_weatherService->call( function, m_locationCode );

  return reply;
}

void reportView::getWeatherData()
{
}

/** Render the document */
void reportView::render(){
    QFont generalFont = KGlobalSettings::generalFont();
    QString fntFamily = generalFont.family();
    int fntSize = generalFont.pointSize();
    if (fntSize == -1)
       fntSize = QFontInfo(generalFont).pointSize();

    QString textColor = KGlobalSettings::textColor().name();
    QString baseColor = KGlobalSettings::baseColor().name();
    QColorGroup cg = palette().active();
    QString bgColor = cg.background().name();
    QString hlColor = cg.highlight().name();
    QString hlTextColor = cg.highlightedText().name();

    QString locationName = callDCOP("stationName");
    QString temp = callDCOP( "temperature" );
    QString dewPoint = callDCOP( "dewPoint" );
    QString relHumidity = callDCOP( "relativeHumidity" );
    QString heatIndex = callDCOP( "heatIndex" );
    QString windChill = callDCOP( "windChill" );
    QString pressure = callDCOP( "pressure" );
    QString wind = callDCOP( "wind" );
    QString sunRiseTime = callDCOP( "sunRiseTime" );
    QString sunSetTime = callDCOP( "sunSetTime" );
    QString date = callDCOP( "date" );
    QString icon = callDCOP( "iconFileName" );
    QStringList cover = callDCOP( "cover" );
    QStringList weather = callDCOP( "weather" );

    setCaption(i18n("Weather Report - ") + locationName );

    QString weatherText = "<ul>\n";

    for (QStringList::const_iterator it = cover.begin(); 
            it != cover.end(); ++it)
        weatherText += "<li>" + *it + "\n";

    for (QStringList::const_iterator it = weather.begin(); 
            it != weather.end(); ++it)
        weatherText += "<li>" + *it + "\n";

    weatherText += "</ul>\n";

    QString contents =
    "<html><head><style type=\"text/css\">" +
    QString("body { font-family: \"%1\"; font-size: %2pt; color: %3; background-color: %4; }\n")
    .arg(fntFamily).arg(fntSize).arg(textColor).arg(baseColor) +
    QString("div.headerTitle { background-color: %1; color: %2; padding: 4px; font-size: 120%; border: solid %3 1px; }\n")
    .arg(hlColor).arg(hlTextColor).arg(textColor) +
    QString("div.headerMsg { background-color: %1; color: %2; border-bottom: solid %3 1px; "
    "border-left: solid %4 1px; border-right: solid %5 1px; margin-bottom: 1em; padding: 2px; }\n")
    .arg(bgColor).arg(textColor).arg(textColor).arg(textColor).arg(textColor) +
    "</style><title></title></head><body>"
    "<div class=\"headerTitle\"><b>" + i18n( "Weather Report - " )
    + locationName + "</b></div>\n" +
    QString("<div class=\"headerMsg\"><b>" + i18n( "Last updated on %1" ) + "</b></div>\n"
    "<table><tr><td width=\"60\" style=\"text-align: center; border: dotted %2 1px;\">"
    "<img width=\"64\" height=\"64\" src=\"%3\" /></td>"
    "<td style=\"vertical-align: top\">%4</td></tr>")
    .arg(date).arg(bgColor).arg(KURL(icon).url()).arg(weatherText) +
    "</table><table>" +
    QString("<tr><th style=\"text-align: right\">" + i18n( "Temperature:" )
    + "</th><td>%1</td>"
    "<td width=\"50\">&nbsp;</td>"
    "<th style=\"text-align: right\">" + i18n( "Dew Point:" )
    + "</th><td>%2</td></tr>"
    "<tr><th style=\"text-align: right\">" + i18n( "Air Pressure:" )
    + "</th><td>%3</td>"
    "<td width=\"50\">&nbsp;</td>"
    "<th style=\"text-align: right\">" + i18n( "Rel. Humidity:" )
    + "</th><td>%4</td></tr>"
    "<tr><th style=\"text-align: right\">" + i18n( "Wind Speed:" )
    + "</th><td>%5</td>")
    .arg(temp).arg(dewPoint).arg(pressure).arg(relHumidity)
    .arg(wind) + "<td width=\"50\">&nbsp;</td>";

    if (!heatIndex.isEmpty())
        contents += QString("<th style=\"text-align: right\">"
        + i18n( "Heat Index:" ) + "</th><td>%1</td>").arg(heatIndex);
    else if (!windChill.isEmpty())
        contents += QString("<th style=\"text-align: right\">"
        + i18n( "Wind Chill:" ) + "</th><td>%1</td>").arg(windChill);
    else
        contents += "<td>&nbsp;</td><td>&nbsp;</td>";
    contents += "</tr>";

    contents += QString("<tr><th style=\"text-align: right\">"
    + i18n( "Sun Rise:" ) + "</th><td>%1</td>" +
    "<td width=\"50\">&nbsp;</td><th style=\"text-align: right\">"
    + i18n( "Sun Set:" ) + "</th><td>%2</td>")
    .arg(sunRiseTime).arg(sunSetTime);

    contents += "</tr></table></body></html>";

    m_reportView->begin();
    m_reportView->write( contents );
    m_reportView->end();
}

/* vim: et sw=4 ts=4
*/

#include "reportview.moc"
